/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.hosts;

import com.logicalclocks.servicediscoverclient.Builder;
import com.logicalclocks.servicediscoverclient.ServiceDiscoveryClient;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceNotFoundException;
import com.logicalclocks.servicediscoverclient.resolvers.DnsResolver;
import com.logicalclocks.servicediscoverclient.resolvers.Type;
import com.logicalclocks.servicediscoverclient.service.Service;
import com.logicalclocks.servicediscoverclient.service.ServiceQuery;
import io.hops.hopsworks.common.util.Settings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang3.NotImplementedException;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ServiceDiscoveryController {
    private static final Logger LOG = Logger.getLogger(ServiceDiscoveryController.class.getName());
    private static final String CONSUL_SERVICE_TEMPLATE = "%s.service.%s";
    private final Map<Type, ServiceDiscoveryClient> clients = new HashMap<Type, ServiceDiscoveryClient>(1);
    @EJB
    private Settings settings;

    @PostConstruct
    public void init() {
        try {
            ServiceDiscoveryClient dnsClient = this.createClient(Type.DNS);
            this.clients.put(Type.DNS, dnsClient);
        }
        catch (ServiceDiscoveryException ex) {
            LOG.log(Level.SEVERE, "Failed to initialize Service Discovery client", ex);
        }
    }

    @PreDestroy
    public void tearDown() {
        for (Map.Entry<Type, ServiceDiscoveryClient> client : this.clients.entrySet()) {
            client.getValue().close();
        }
    }

    @Lock(value=LockType.READ)
    public String constructServiceFQDN(HopsworksService service) {
        String serviceName = service.getServiceName();
        if (serviceName.endsWith(".")) {
            serviceName = serviceName.substring(0, serviceName.length() - 1);
        }
        return String.format(CONSUL_SERVICE_TEMPLATE, serviceName, this.settings.getServiceDiscoveryDomain());
    }

    @Lock(value=LockType.READ)
    public String constructServiceFQDNWithPort(HopsworksService hopsworksService) throws ServiceDiscoveryException {
        Service service = this.getAnyAddressOfServiceWithDNS(hopsworksService);
        return service.getName() + ":" + service.getPort();
    }

    @Lock(value=LockType.READ)
    public String constructServiceAddressWithPort(HopsworksService hopsworksService) throws ServiceDiscoveryException {
        Service service = this.getAnyAddressOfServiceWithDNS(hopsworksService);
        return service.getAddress() + ":" + service.getPort();
    }

    @Lock(value=LockType.READ)
    public Stream<Service> getService(Type resolverType, ServiceQuery serviceQuery) throws ServiceDiscoveryException {
        ServiceDiscoveryClient client = this.getClient(resolverType);
        return client.getService(serviceQuery);
    }

    @Lock(value=LockType.READ)
    public Service getAnyAddressOfServiceWithDNS(HopsworksService serviceName) throws ServiceDiscoveryException {
        ServiceQuery serviceQuery = ServiceQuery.of((String)this.constructServiceFQDN(serviceName), Collections.emptySet());
        Optional<Service> serviceOpt = this.getService(Type.DNS, serviceQuery).findAny();
        return serviceOpt.orElseThrow(() -> new ServiceNotFoundException("Could not find service with: " + serviceQuery));
    }

    @Lock(value=LockType.READ)
    public Service getAnyAddressOfServiceWithDNSSRVOnly(HopsworksService serviceName) throws ServiceDiscoveryException {
        ServiceQuery serviceQuery = ServiceQuery.of((String)this.constructServiceFQDN(serviceName), Collections.emptySet());
        DnsResolver client = (DnsResolver)this.getClient(Type.DNS);
        Optional serviceOpt = client.getServiceSRVOnly(serviceQuery).findAny();
        return (Service)serviceOpt.orElseThrow(() -> new ServiceNotFoundException("Could not find service with: " + serviceQuery));
    }

    @Lock(value=LockType.READ)
    public String getConsulServerAddress() throws ServiceDiscoveryException {
        Service consulService = this.getAnyAddressOfServiceWithDNS(HopsworksService.CONSUL_SERVER);
        return consulService.getAddress();
    }

    private ServiceDiscoveryClient getClient(Type type) throws ServiceDiscoveryException {
        ServiceDiscoveryClient client = this.clients.get(type);
        if (client != null) {
            return client;
        }
        throw new ServiceDiscoveryException("Could not find initialized Service Discovery client of type " + type + " Was it initialized correctly?");
    }

    private ServiceDiscoveryClient createClient(Type type) throws ServiceDiscoveryException {
        switch (type) {
            case DNS: {
                return new Builder(type).build();
            }
            case HTTP: 
            case CACHING: {
                throw new NotImplementedException(type + " resolver is not implemented yet");
            }
        }
        throw new RuntimeException("Unknown Service Discovery resolver type: " + type);
    }

    public static enum HopsworksService {
        LIVY("livy"),
        ZOOKEEPER_CLIENT("client.zookeeper"),
        SPARK_HISTORY_SERVER("sparkhistoryserver"),
        HTTPS_RESOURCEMANAGER("https.resourcemanager"),
        HIVE_SERVER_PLAIN("hiveserver2-plain.hive"),
        HIVE_SERVER_TLS("hiveserver2-tls.hive"),
        HIVE_METASTORE("metastore.hive"),
        RPC_NAMENODE("rpc.namenode"),
        SERVING_LOGSTASH("serving.logstash"),
        TF_SERVING_LOGSTASH("tfserving.logstash"),
        SKLEARN_SERVING_LOGSTASH("sklearnserving.logstash"),
        PYTHON_JOBS_LOGSTASH("pythonjobs.logstash"),
        HOPSWORKS_APP("hopsworks.glassfish"),
        JUPYTER_LOGSTASH("jupyter.logstash"),
        REGISTRY("registry"),
        CONSUL_SERVER("consul"),
        ONLINEFS_MYSQL("onlinefs.mysql"),
        RESOURCEMANAGER("resourcemanager"),
        PUSHGATEWAY("pushgateway.prometheus"),
        PROMETHEUS("prometheus"),
        NODE_EXPORTER("node_exporter");

        private String name;

        private HopsworksService(String name) {
            this.name = name;
        }

        public String getServiceName() {
            return this.name;
        }
    }
}

