/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.serving.sklearn;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import io.hops.hopsworks.common.dao.serving.ServingFacade;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServingException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.serving.Serving;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class LocalhostSkLearnServingController {
    private static final Logger logger = Logger.getLogger(LocalhostSkLearnServingController.class.getName());
    @EJB
    private ServingFacade servingFacade;
    @EJB
    private Settings settings;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private ProjectUtils projectUtils;

    public int getMaxNumInstances() {
        return 1;
    }

    public String getClassName() {
        return LocalhostSkLearnServingController.class.getName();
    }

    public void killServingInstance(Project project, Serving serving, boolean releaseLock) throws ServingException {
        String script = this.settings.getSudoersDir() + "/sklearn_serving.sh";
        Path secretDir = Paths.get(this.settings.getStagingDir(), "/serving/" + serving.getLocalDir());
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(script).addCommand("kill").addCommand(serving.getCid()).addCommand(serving.getName()).addCommand(serving.getProject().getName().toLowerCase()).addCommand(secretDir.toString()).ignoreOutErrStreams(true).build();
        logger.log(Level.FINE, processDescriptor.toString());
        try {
            this.osProcessExecutor.execute(processDescriptor);
        }
        catch (IOException ex) {
            throw new ServingException(RESTCodes.ServingErrorCode.LIFECYCLEERROR, Level.SEVERE, "serving id: " + serving.getId(), ex.getMessage(), (Throwable)ex);
        }
        serving.setCid("stopped");
        serving.setLocalPort(Integer.valueOf(-1));
        serving.setDeployed(null);
        this.servingFacade.updateDbObject(serving, project);
        if (releaseLock) {
            this.servingFacade.releaseLock(project, serving.getId());
        }
    }

    public void startServingInstance(Project project, Users user, Serving serving) throws ServingException {
        String script = this.settings.getSudoersDir() + "/sklearn_serving.sh";
        Integer port = ThreadLocalRandom.current().nextInt(40000, 59999);
        Path secretDir = Paths.get(this.settings.getStagingDir(), "/serving/" + serving.getLocalDir());
        String predictorFilename = serving.getPredictor();
        if (serving.getPredictor().contains("/")) {
            String[] splits = serving.getPredictor().split("/");
            predictorFilename = splits[splits.length - 1];
        }
        try {
            ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(script).addCommand("start").addCommand(predictorFilename).addCommand(Paths.get(serving.getPredictor(), new String[0]).toString()).addCommand(String.valueOf(port)).addCommand(secretDir.toString()).addCommand(project.getName() + "__" + user.getUsername()).addCommand(project.getName().toLowerCase()).addCommand(this.settings.getAnacondaProjectDir() + "/bin/python").addCommand(this.certificateMaterializer.getUserTransientKeystorePath(project, user)).addCommand(this.certificateMaterializer.getUserTransientTruststorePath(project, user)).addCommand(this.certificateMaterializer.getUserTransientPasswordPath(project, user)).addCommand(serving.getName()).addCommand(this.projectUtils.getFullDockerImageName(project, false)).setWaitTimeout(2L, TimeUnit.MINUTES).ignoreOutErrStreams(true).build();
            logger.log(Level.FINE, processDescriptor.toString());
            this.certificateMaterializer.materializeCertificatesLocal(user.getUsername(), project.getName());
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                serving.setCid("stopped");
                this.servingFacade.updateDbObject(serving, project);
                throw new ServingException(RESTCodes.ServingErrorCode.LIFECYCLEERRORINT, Level.WARNING, "Could not start sklearn serving", "ut:" + processResult.getStdout() + ", err:" + processResult.getStderr());
            }
            Path pidFilePath = Paths.get(secretDir.toString(), "sklearn_flask_server.pid");
            String pidContents = Files.readFirstLine((File)pidFilePath.toFile(), (Charset)Charset.defaultCharset());
            for (int pidReadCounter = 0; Strings.isNullOrEmpty((String)pidContents) && pidReadCounter < 10; ++pidReadCounter) {
                logger.log(Level.FINE, "Waiting for sklearn to start...");
                Thread.sleep(1000L);
                pidContents = Files.readFirstLine((File)pidFilePath.toFile(), (Charset)Charset.defaultCharset());
            }
            if (Strings.isNullOrEmpty((String)pidContents)) {
                throw new ServingException(RESTCodes.ServingErrorCode.LIFECYCLEERRORINT, Level.WARNING, "Could not start sklearn serving because pid file could not be read or was empty");
            }
            logger.log(Level.FINE, "sklearn pidContents:" + pidContents);
            serving.setCid(pidContents);
            serving.setLocalPort(port);
            serving.setDeployed(new Date());
            this.servingFacade.updateDbObject(serving, project);
        }
        catch (Exception ex) {
            serving.setCid("stopped");
            this.servingFacade.updateDbObject(serving, project);
            throw new ServingException(RESTCodes.ServingErrorCode.LIFECYCLEERRORINT, Level.SEVERE, null, ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (this.settings.getHopsRpcTls()) {
                this.certificateMaterializer.removeCertificatesLocal(user.getUsername(), project.getName());
            }
            this.servingFacade.releaseLock(project, serving.getId());
        }
    }
}

