/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.pythonresources;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.service.Service;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.util.PrometheusClient;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.json.JSONArray;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class PythonResourcesController {
    private static final Logger LOGGER = Logger.getLogger(PythonResourcesController.class.getName());
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    @EJB
    private PrometheusClient client;
    @EJB
    private Settings settings;
    private static JSONObject pythonResources = new JSONObject();
    private final String DOCKER_TOTAL_ALLOCATABLE_CPU_KEY = "docker_allocatable_cpu";
    private final String DOCKER_CURRENT_CPU_USAGE_KEY = "docker_current_cpu_usage";
    private final String DOCKER_TOTAL_ALLOCATABLE_MEMORY_KEY = "docker_total_memory";
    private final String DOCKER_CURRENT_MEMORY_USAGE_KEY = "docker_current_memory_usage";
    private final String CLUSTER_TOTAL_MEMORY_CAPACITY = "cluster_total_memory";
    private final String CLUSTER_TOTAL_CPU_CAPACITY = "cluster_total_cpu";
    private final String CLUSTER_CURRENT_MEMORY_USAGE = "cluster_current_memory_usage";
    private final String CLUSTER_CURRENT_CPU_USAGE = "cluster_current_cpu_usage";
    private Integer nodeExporterPort;

    @PostConstruct
    public void init() {
        try {
            Service nodeExporterService = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(ServiceDiscoveryController.HopsworksService.NODE_EXPORTER);
            this.nodeExporterPort = nodeExporterService.getPort();
        }
        catch (ServiceDiscoveryException e) {
            LOGGER.log(Level.INFO, e.getMessage());
        }
    }

    public JSONObject getPythonResources() throws ServiceDiscoveryException {
        Map<String, String> pythonResourcesTypesQueries = this.updatePrometheusQueries();
        pythonResourcesTypesQueries.forEach((key, query) -> this.getResourceValue((String)key, (String)query));
        pythonResources.put("cluster_total_cpu", 100);
        if (!this.settings.isDockerCgroupEnabled() && !this.settings.getKubeInstalled().booleanValue()) {
            pythonResources.put("docker_allocatable_cpu", 100);
            pythonResources.put("docker_total_memory", pythonResources.get("cluster_total_memory"));
            pythonResources.put("docker_current_memory_usage", pythonResources.get("cluster_current_memory_usage"));
            pythonResources.put("docker_current_cpu_usage", pythonResources.get("cluster_current_cpu_usage"));
        }
        return pythonResources;
    }

    private void getResourceValue(String resource, String query) {
        try {
            JSONObject queryResult = this.client.execute(query);
            JSONArray resultObject = queryResult.getJSONObject("data").getJSONArray("result");
            if (resultObject.length() > 0) {
                pythonResources.put(resource, (Object)resultObject.getJSONObject(0).getJSONArray("value").getString(1));
            } else {
                pythonResources.put(resource, (Object)"");
            }
        }
        catch (ServiceException e) {
            pythonResources.put(resource, (Object)"");
        }
    }

    private Map<String, String> updatePrometheusQueries() throws ServiceDiscoveryException {
        HashMap<String, String> pythonResourcesTypesQueries = new HashMap<String, String>();
        if (this.nodeExporterPort == null) {
            Service nodeExporterService = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(ServiceDiscoveryController.HopsworksService.NODE_EXPORTER);
            this.nodeExporterPort = nodeExporterService.getPort();
        }
        String nodeQuery = this.getExcludedNodesInResourceQuery();
        String nodeQueryNoAppend = nodeQuery.replaceAll(",", "");
        pythonResourcesTypesQueries.put("cluster_current_cpu_usage", "100 - ((sum((avg by (instance) (rate(node_cpu_seconds_total{mode='idle'" + nodeQuery + "}[1m])) * 100)))/(count(node_memory_Active_bytes{" + nodeQueryNoAppend + "})))");
        pythonResourcesTypesQueries.put("cluster_current_memory_usage", "sum(node_memory_Active_bytes{" + nodeQueryNoAppend + "})");
        pythonResourcesTypesQueries.put("cluster_total_memory", "sum(node_memory_MemTotal_bytes{" + nodeQueryNoAppend + "})");
        if (this.settings.isDockerCgroupEnabled() && !this.settings.getKubeInstalled().booleanValue()) {
            pythonResourcesTypesQueries.put("docker_current_cpu_usage", "sum(avg by (cpu) (rate(container_cpu_usage_seconds_total{id=~'.*/docker/.*'}[60s]) * 100))");
            pythonResourcesTypesQueries.put("docker_current_memory_usage", "sum(container_memory_working_set_bytes{id=~'.*/docker/.*'})");
            pythonResourcesTypesQueries.put("docker_total_memory", "container_spec_memory_limit_bytes{id='/docker'}");
            pythonResourcesTypesQueries.put("docker_allocatable_cpu", "(container_spec_cpu_quota{id='/docker'}/" + this.settings.getDockerCgroupCpuPeriod() + ")*100");
        } else {
            pythonResourcesTypesQueries.put("docker_current_cpu_usage", "100 - ((sum((avg by (instance) (rate(node_cpu_seconds_total{mode='idle'" + nodeQuery + "}[1m])) * 100)))/(count(node_memory_Active_bytes{" + nodeQueryNoAppend + "})))");
            pythonResourcesTypesQueries.put("docker_total_memory", "sum(node_memory_Active_bytes{" + nodeQueryNoAppend + "})");
            pythonResourcesTypesQueries.put("cluster_total_memory", "sum(node_memory_MemTotal_bytes{" + nodeQueryNoAppend + "})");
        }
        return pythonResourcesTypesQueries;
    }

    private String getExcludedNodesInResourceQuery() {
        if (!this.settings.getKubeInstalled().booleanValue()) {
            return "";
        }
        String taintedNodesStr = this.settings.getKubeTaintedNodes();
        ArrayList nodes = new ArrayList(Arrays.asList(taintedNodesStr.split(",")).stream().filter(n -> !Strings.isNullOrEmpty((String)n)).collect(Collectors.toList()));
        String taintedNodesQuery = "";
        for (int i = 0; i < nodes.size(); ++i) {
            if (i == 0) {
                taintedNodesQuery = taintedNodesQuery + ", instance !~ '";
            }
            taintedNodesQuery = i < nodes.size() - 1 ? taintedNodesQuery + (String)nodes.get(i) + ":" + this.nodeExporterPort + "|" : taintedNodesQuery + (String)nodes.get(i) + ":" + this.nodeExporterPort + "'";
        }
        return taintedNodesQuery;
    }
}

