/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.state;

import com.lambdista.util.Try;
import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.provenance.core.opensearch.BasicOpenSearchHit;
import io.hops.hopsworks.common.provenance.state.dto.ProvStateDTO;
import io.hops.hopsworks.common.provenance.util.ProvHelper;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javatuples.Pair;
import org.opensearch.search.sort.SortOrder;

public class ProvStateParser {
    private static final Logger LOGGER = Logger.getLogger(ProvStateParser.class.getName());

    private static <V> V onlyAllowed() throws ProvenanceException {
        String msg = "allowed fields:" + EnumSet.allOf(FieldsP.class) + " or " + EnumSet.allOf(FieldsPF.class);
        throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg);
    }

    public static Field extractField(String val) throws ProvenanceException {
        try {
            return FieldsP.valueOf(val.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            try {
                return FieldsPF.valueOf(val.toUpperCase());
            }
            catch (IllegalArgumentException | NullPointerException runtimeException2) {
                return (Field)ProvStateParser.onlyAllowed();
            }
        }
    }

    public static Pair<Field, Object> extractFilter(String param) throws ProvenanceException {
        String rawVal;
        String rawFilter;
        if (param.contains(":")) {
            int aux = param.indexOf(58);
            rawFilter = param.substring(0, aux);
            rawVal = param.substring(aux + 1);
        } else {
            rawFilter = param;
            rawVal = "true";
        }
        Field field = ProvStateParser.extractField(rawFilter);
        Object parsedVal = field.filterValParser().apply(rawVal);
        return Pair.with((Object)field, parsedVal);
    }

    public static Pair<ProvParser.Field, SortOrder> extractSort(String param) throws ProvenanceException {
        String rawSortOrder;
        String rawSortField;
        if (param.contains(":")) {
            int aux = param.indexOf(58);
            rawSortField = param.substring(0, aux);
            rawSortOrder = param.substring(aux + 1);
        } else {
            rawSortField = param;
            rawSortOrder = "ASC";
        }
        Field field = ProvStateParser.extractField(rawSortField);
        SortOrder sortOrder = ProvParser.extractSortOrder(rawSortOrder);
        return Pair.with((Object)field, (Object)sortOrder);
    }

    public static ProvStateDTO instance(BasicOpenSearchHit hit) throws ProvenanceException {
        ProvStateDTO result = new ProvStateDTO();
        result.setId(hit.getId());
        result.setScore(Float.valueOf(Float.isNaN(hit.getScore().floatValue()) ? 0.0f : hit.getScore().floatValue()));
        return ProvStateParser.instance(result, new HashMap<String, Object>(hit.getSource()));
    }

    public static Try<ProvStateDTO> tryInstance(BasicOpenSearchHit hit) {
        return Try.apply(() -> ProvStateParser.instance(hit));
    }

    private static ProvStateDTO instance(ProvStateDTO result, Map<String, Object> auxMap) throws ProvenanceException {
        try {
            result.setProjectInodeId((Long)ProvHelper.extractOpenSearchField(auxMap, FieldsP.PROJECT_I_ID));
            result.setInodeId((Long)ProvHelper.extractOpenSearchField(auxMap, FieldsP.FILE_I_ID));
            result.setAppId((String)ProvHelper.extractOpenSearchField(auxMap, FieldsP.APP_ID));
            result.setUserId((Integer)ProvHelper.extractOpenSearchField(auxMap, FieldsP.USER_ID));
            result.setInodeName((String)ProvHelper.extractOpenSearchField(auxMap, FieldsP.FILE_NAME));
            result.setCreateTime((Long)ProvHelper.extractOpenSearchField(auxMap, FieldsP.CREATE_TIMESTAMP));
            result.setMlType((Provenance.MLType)((Object)ProvHelper.extractOpenSearchField(auxMap, FieldsP.ML_TYPE)));
            result.setMlId((String)ProvHelper.extractOpenSearchField(auxMap, FieldsP.ML_ID));
            result.setDatasetInodeId((Long)ProvHelper.extractOpenSearchField(auxMap, FieldsP.DATASET_I_ID));
            result.setParentInodeId((Long)ProvHelper.extractOpenSearchField(auxMap, FieldsP.PARENT_I_ID));
            result.setPartitionId((Long)ProvHelper.extractOpenSearchField(auxMap, FieldsP.PARTITION_ID));
            result.setProjectName((String)ProvHelper.extractOpenSearchField(auxMap, FieldsP.PROJECT_NAME));
            result.setReadableCreateTime((String)ProvHelper.extractOpenSearchField(auxMap, FieldsP.R_CREATE_TIMESTAMP));
            ProvHelper.extractOpenSearchField(auxMap, FieldsP.ENTRY_TYPE);
            result.setXattrs(ProvHelper.extractOpenSearchField(auxMap, ProvParser.XAttrField.XATTR_PROV, ProvHelper.asXAttrMap(), true));
            if (result.getXattrs() != null && result.getXattrs().containsKey(FieldsP.APP_ID.toString())) {
                result.setAppId((String)ProvHelper.extractOpenSearchField(result.getXattrs().get(ProvParser.Fields.APP_ID.toString())));
            }
            if (!auxMap.isEmpty()) {
                LOGGER.log(Level.FINE, "fields:{0} not managed in file state return", auxMap.keySet());
            }
        }
        catch (ClassCastException e) {
            String msg = "mismatch between DTO class and ProvSParser field types (opensearch)";
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.WARNING, msg, msg, (Throwable)e);
        }
        return result;
    }

    public static enum FieldsPF implements Field
    {
        FILE_NAME_LIKE(FieldsP.FILE_NAME, ProvParser.FilterType.LIKE),
        CREATE_TIMESTAMP_LT(FieldsP.CREATE_TIMESTAMP, ProvParser.FilterType.RANGE_LT),
        CREATE_TIMESTAMP_LTE(FieldsP.CREATE_TIMESTAMP, ProvParser.FilterType.RANGE_LTE),
        CREATE_TIMESTAMP_GT(FieldsP.CREATE_TIMESTAMP, ProvParser.FilterType.RANGE_GT),
        CREATE_TIMESTAMP_GTE(FieldsP.CREATE_TIMESTAMP, ProvParser.FilterType.RANGE_GTE);

        FieldsP base;
        ProvParser.FilterType filterType;

        private FieldsPF(FieldsP base, ProvParser.FilterType filterType) {
            this.base = base;
            this.filterType = filterType;
        }

        @Override
        public String openSearchFieldName() {
            return this.base.openSearchFieldName();
        }

        @Override
        public String queryFieldName() {
            return this.base.openSearchFieldName();
        }

        @Override
        public ProvParser.FilterType filterType() {
            return this.filterType;
        }

        public ProvParser.ValParser filterValParser() {
            return this.base.filterValParser();
        }
    }

    public static enum FieldsP implements Field
    {
        PROJECT_I_ID(ProvParser.Fields.PROJECT_I_ID, new ProvParser.LongValParser()),
        DATASET_I_ID(ProvParser.Fields.DATASET_I_ID, new ProvParser.LongValParser()),
        PARENT_I_ID(ProvParser.Fields.PARENT_I_ID, new ProvParser.LongValParser()),
        FILE_I_ID(ProvParser.Fields.INODE_ID, new ProvParser.LongValParser()),
        FILE_NAME(ProvParser.Fields.INODE_NAME, new ProvParser.StringValParser()),
        PROJECT_NAME(ProvParser.AuxField.PROJECT_NAME, new ProvParser.StringValParser()),
        USER_ID(ProvParser.Fields.USER_ID, new ProvParser.IntValParser()),
        APP_ID(ProvParser.Fields.APP_ID, new ProvParser.StringValParser()),
        ML_TYPE(ProvParser.Fields.ML_TYPE, new ProvParser.MLTypeValParser()),
        ML_ID(ProvParser.Fields.ML_ID, new ProvParser.StringValParser()),
        PARTITION_ID(ProvParser.AuxField.PARTITION_ID, new ProvParser.LongValParser()),
        CREATE_TIMESTAMP(Fields.CREATE_TIMESTAMP, new ProvParser.LongValParser()),
        R_CREATE_TIMESTAMP(Fields.R_CREATE_TIMESTAMP, new ProvParser.StringValParser()),
        ENTRY_TYPE(ProvParser.Fields.ENTRY_TYPE, new ProvParser.StringValParser());

        ProvParser.OpenSearchField openSearchField;
        ProvParser.ValParser<?> filterValParser;

        private FieldsP(ProvParser.OpenSearchField openSearchField, ProvParser.ValParser<?> filterValParser) {
            this.openSearchField = openSearchField;
            this.filterValParser = filterValParser;
        }

        @Override
        public String openSearchFieldName() {
            return this.openSearchField.toString().toLowerCase();
        }

        @Override
        public String queryFieldName() {
            return this.name().toLowerCase();
        }

        @Override
        public ProvParser.FilterType filterType() {
            return ProvParser.FilterType.EXACT;
        }

        public ProvParser.ValParser filterValParser() {
            return this.filterValParser;
        }
    }

    public static enum Fields implements ProvParser.OpenSearchField
    {
        CREATE_TIMESTAMP,
        R_CREATE_TIMESTAMP;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static interface Field
    extends ProvParser.Field {
    }
}

