/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.git;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.git.GitRepository;
import io.hops.hopsworks.persistence.entity.git.config.GitProvider;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class GitRepositoryFacade
extends AbstractFacade<GitRepository> {
    private static final Logger LOGGER = Logger.getLogger(GitRepositoryFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public GitRepositoryFacade() {
        super(GitRepository.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public Optional<GitRepository> findById(Integer repoId) {
        try {
            return Optional.of(this.em.createNamedQuery("GitRepository.findById", GitRepository.class).setParameter("id", (Object)repoId).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public AbstractFacade.CollectionInfo<GitRepository> getAllInProject(Project project, Integer limit, Integer offset) {
        TypedQuery repoQuery = this.em.createNamedQuery("GitRepository.findAllInProject", GitRepository.class);
        repoQuery.setParameter("project", (Object)project);
        this.setOffsetAndLim(offset, limit, (Query)repoQuery);
        TypedQuery countQuery = this.em.createQuery("SELECT COUNT(r.id) FROM GitRepository r WHERE r.project = :project", GitRepository.class);
        countQuery.setParameter("project", (Object)project);
        return new AbstractFacade.CollectionInfo<GitRepository>((Long)countQuery.getSingleResult(), repoQuery.getResultList());
    }

    public List<GitRepository> findAllWithOngoingOperations() {
        return this.em.createNamedQuery("GitRepository.findAllWithRunningOperation", GitRepository.class).getResultList();
    }

    public Optional<GitRepository> findByIdAndProject(Project project, Integer repoId) {
        try {
            return Optional.of(this.em.createNamedQuery("GitRepository.findByIdAndProject", GitRepository.class).setParameter("id", (Object)repoId).setParameter("project", (Object)project).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<GitRepository> findByInode(Inode inode) {
        try {
            return Optional.of(this.em.createNamedQuery("GitRepository.findByInode", GitRepository.class).setParameter("inode", (Object)inode).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public GitRepository create(Inode inode, Project project, GitProvider gitProvider, Users user) {
        GitRepository gitRepository = new GitRepository(inode, project, gitProvider, user);
        this.em.persist((Object)gitRepository);
        this.em.flush();
        return gitRepository;
    }

    public GitRepository updateRepository(GitRepository repository) {
        return super.update(repository);
    }

    public GitRepository updateRepositoryCid(GitRepository repository, String pid) {
        repository.setCid(pid);
        return this.updateRepository(repository);
    }
}

