/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.datavalidationv2;

import io.hops.hopsworks.common.api.RestDTO;
import io.hops.hopsworks.common.featurestore.datavalidationv2.ValidationResultDTO;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.IngestionResult;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.ValidationReport;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.ValidationResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ValidationReportDTO
extends RestDTO<ValidationReportDTO> {
    @XmlElement
    private Integer id;
    @XmlElement
    private String evaluationParameters;
    @XmlElement
    private String statistics;
    @XmlElement
    private List<ValidationResultDTO> results;
    @XmlElement
    private String meta;
    @XmlElement
    private Boolean success;
    @XmlElement
    private Date validationTime;
    @XmlElement
    private String fullReportPath = null;
    @XmlElement
    private String fullJson;
    @XmlElement
    private IngestionResult ingestionResult;

    public ValidationReportDTO() {
    }

    public ValidationReportDTO(String statistics, String meta, Boolean success, List<ValidationResultDTO> validationResults, String evaluationParameters) {
        this.statistics = statistics;
        this.meta = meta;
        this.success = success;
        this.results = validationResults;
        this.evaluationParameters = evaluationParameters;
    }

    public ValidationReportDTO(ValidationReport validationReport) {
        this.id = validationReport.getId();
        this.meta = validationReport.getMeta();
        this.statistics = validationReport.getStatistics();
        this.success = validationReport.getSuccess();
        this.evaluationParameters = validationReport.getEvaluationParameters();
        this.validationTime = validationReport.getValidationTime();
        ArrayList<ValidationResultDTO> validationResultDTOs = new ArrayList<ValidationResultDTO>();
        for (ValidationResult validationResult : validationReport.getValidationResults()) {
            ValidationResultDTO validationResultDTO = new ValidationResultDTO(validationResult);
            validationResultDTOs.add(validationResultDTO);
        }
        this.results = validationResultDTOs;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getStatistics() {
        return this.statistics;
    }

    public void setStatistics(String statistics) {
        this.statistics = statistics;
    }

    public String getMeta() {
        return this.meta;
    }

    public void setMeta(String meta) {
        this.meta = meta;
    }

    public String getFullJson() {
        return this.fullJson;
    }

    public void setFullJson(String fullJson) {
        this.fullJson = fullJson;
    }

    public String getFullReportPath() {
        return this.fullReportPath;
    }

    public void setFullReportPath(String fullReportPath) {
        this.fullReportPath = fullReportPath;
    }

    public String getEvaluationParameters() {
        return this.evaluationParameters;
    }

    public void setEvaluationParameters(String evaluationParameters) {
        this.evaluationParameters = evaluationParameters;
    }

    public List<ValidationResultDTO> getResults() {
        return this.results;
    }

    public void setResults(List<ValidationResultDTO> results) {
        this.results = results;
    }

    public Date getValidationTime() {
        return this.validationTime;
    }

    public void setValidationTime(Date validationTime) {
        this.validationTime = validationTime;
    }

    public IngestionResult getIngestionResult() {
        return this.ingestionResult;
    }

    public void setIngestionResult(IngestionResult ingestionResult) {
        this.ingestionResult = ingestionResult;
    }

    public String toString() {
        return "ValidationReportDTO{id=" + this.id + ", evaluationParameters='" + this.evaluationParameters + '\'' + ", statistics='" + this.statistics + '\'' + ", results=" + this.results + ", meta='" + this.meta + '\'' + ", success=" + this.success + ", validationTime=" + this.validationTime + ", fullReportPath='" + this.fullReportPath + '\'' + ", ingestionResult=" + this.ingestionResult + '}';
    }
}

