/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.snowflake;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.featurestore.storageconnectors.StorageConnectorUtil;
import io.hops.hopsworks.common.featurestore.storageconnectors.snowflake.FeaturestoreSnowflakeConnectorDTO;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.snowflake.FeaturestoreSnowflakeConnector;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.secrets.Secret;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.transaction.Transactional;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturestoreSnowflakeConnectorController {
    private static final Logger LOGGER = Logger.getLogger(FeaturestoreSnowflakeConnectorController.class.getName());
    @EJB
    private SecretsController secretsController;
    @EJB
    private StorageConnectorUtil storageConnectorUtil;

    public FeaturestoreSnowflakeConnectorDTO getConnector(FeaturestoreConnector featurestoreConnector) throws FeaturestoreException {
        FeaturestoreSnowflakeConnectorDTO snowflakeConnectorDTO = new FeaturestoreSnowflakeConnectorDTO(featurestoreConnector);
        snowflakeConnectorDTO.setSfOptions(this.storageConnectorUtil.toOptions(featurestoreConnector.getSnowflakeConnector().getArguments()));
        snowflakeConnectorDTO.setPassword(this.storageConnectorUtil.getSecret(featurestoreConnector.getSnowflakeConnector().getPwdSecret(), String.class));
        snowflakeConnectorDTO.setToken(this.storageConnectorUtil.getSecret(featurestoreConnector.getSnowflakeConnector().getTokenSecret(), String.class));
        return snowflakeConnectorDTO;
    }

    public FeaturestoreSnowflakeConnector createConnector(Users user, Featurestore featurestore, FeaturestoreSnowflakeConnectorDTO featurestoreSnowflakeConnectorDTO) throws FeaturestoreException, UserException, ProjectException {
        this.verifyConnectorDTO(featurestoreSnowflakeConnectorDTO);
        Secret secret = this.createSecret(user, featurestore, featurestoreSnowflakeConnectorDTO);
        FeaturestoreSnowflakeConnector snowflakeConnector = new FeaturestoreSnowflakeConnector();
        this.setConnector(snowflakeConnector, secret, featurestoreSnowflakeConnectorDTO);
        return snowflakeConnector;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Transactional(rollbackOn={FeaturestoreException.class})
    public FeaturestoreSnowflakeConnector updateConnector(Users user, FeaturestoreSnowflakeConnectorDTO featurestoreSnowflakeConnectorDTO, FeaturestoreSnowflakeConnector snowflakeConnector) throws FeaturestoreException, UserException, ProjectException {
        this.verifyConnectorDTO(featurestoreSnowflakeConnectorDTO);
        Secret secret = this.updateSecret(user, featurestoreSnowflakeConnectorDTO, snowflakeConnector);
        this.setConnector(snowflakeConnector, secret, featurestoreSnowflakeConnectorDTO);
        return snowflakeConnector;
    }

    private void setConnector(FeaturestoreSnowflakeConnector snowflakeConnector, Secret secret, FeaturestoreSnowflakeConnectorDTO featurestoreSnowflakeConnectorDTO) {
        snowflakeConnector.setUrl(this.storageConnectorUtil.getValueOrNull(featurestoreSnowflakeConnectorDTO.getUrl()));
        snowflakeConnector.setDatabaseUser(this.storageConnectorUtil.getValueOrNull(featurestoreSnowflakeConnectorDTO.getUser()));
        snowflakeConnector.setDatabaseName(this.storageConnectorUtil.getValueOrNull(featurestoreSnowflakeConnectorDTO.getDatabase()));
        snowflakeConnector.setDatabaseSchema(this.storageConnectorUtil.getValueOrNull(featurestoreSnowflakeConnectorDTO.getSchema()));
        snowflakeConnector.setTableName(this.storageConnectorUtil.getValueOrNull(featurestoreSnowflakeConnectorDTO.getTable()));
        snowflakeConnector.setRole(this.storageConnectorUtil.getValueOrNull(featurestoreSnowflakeConnectorDTO.getRole()));
        snowflakeConnector.setWarehouse(this.storageConnectorUtil.getValueOrNull(featurestoreSnowflakeConnectorDTO.getWarehouse()));
        snowflakeConnector.setArguments(this.storageConnectorUtil.fromOptions(featurestoreSnowflakeConnectorDTO.getSfOptions()));
        snowflakeConnector.setApplication(featurestoreSnowflakeConnectorDTO.getApplication());
        if (!Strings.isNullOrEmpty((String)featurestoreSnowflakeConnectorDTO.getPassword())) {
            snowflakeConnector.setPwdSecret(secret);
            snowflakeConnector.setTokenSecret(null);
        } else {
            snowflakeConnector.setTokenSecret(secret);
            snowflakeConnector.setPwdSecret(null);
        }
    }

    private Secret getSecret(FeaturestoreSnowflakeConnector snowflakeConnector) {
        if (snowflakeConnector.getPwdSecret() != null) {
            return snowflakeConnector.getPwdSecret();
        }
        return snowflakeConnector.getTokenSecret();
    }

    private Secret createSecret(Users user, Featurestore featurestore, FeaturestoreSnowflakeConnectorDTO featurestoreSnowflakeConnectorDTO) throws ProjectException, UserException {
        String secretName = this.storageConnectorUtil.createSecretName(featurestore.getId(), featurestoreSnowflakeConnectorDTO.getName(), featurestoreSnowflakeConnectorDTO.getStorageConnectorType());
        Secret secret = !Strings.isNullOrEmpty((String)featurestoreSnowflakeConnectorDTO.getPassword()) ? this.secretsController.createSecretForProject(user, secretName, featurestoreSnowflakeConnectorDTO.getPassword(), featurestore.getProject().getId()) : this.secretsController.createSecretForProject(user, secretName, featurestoreSnowflakeConnectorDTO.getToken(), featurestore.getProject().getId());
        return secret;
    }

    private Secret updateSecret(Users user, FeaturestoreSnowflakeConnectorDTO featurestoreSnowflakeConnectorDTO, FeaturestoreSnowflakeConnector snowflakeConnector) throws UserException, ProjectException {
        Secret existingSecret = this.getSecret(snowflakeConnector);
        this.secretsController.checkCanAccessSecret(existingSecret, user);
        String secret = !Strings.isNullOrEmpty((String)featurestoreSnowflakeConnectorDTO.getPassword()) ? featurestoreSnowflakeConnectorDTO.getPassword() : featurestoreSnowflakeConnectorDTO.getToken();
        try {
            existingSecret.setSecret(this.secretsController.encryptSecret(secret));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new UserException(RESTCodes.UserErrorCode.SECRET_ENCRYPTION_ERROR, Level.SEVERE, "Error encrypting secret", "Could not encrypt Secret " + existingSecret.getId().getName(), (Throwable)e);
        }
        return existingSecret;
    }

    private void verifyConnectorDTO(FeaturestoreSnowflakeConnectorDTO featurestoreSnowflakeConnectorDTO) throws FeaturestoreException {
        if (featurestoreSnowflakeConnectorDTO == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Null input data");
        }
        if (this.storageConnectorUtil.isNullOrWhitespace(featurestoreSnowflakeConnectorDTO.getUrl())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Url can not be empty");
        }
        if (this.storageConnectorUtil.isNullOrWhitespace(featurestoreSnowflakeConnectorDTO.getUser())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "User can not be empty");
        }
        if (this.storageConnectorUtil.isNullOrWhitespace(featurestoreSnowflakeConnectorDTO.getSchema())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Schema can not be empty");
        }
        if (this.storageConnectorUtil.isNullOrWhitespace(featurestoreSnowflakeConnectorDTO.getDatabase())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Database can not be empty");
        }
        if (Strings.isNullOrEmpty((String)featurestoreSnowflakeConnectorDTO.getPassword()) && Strings.isNullOrEmpty((String)featurestoreSnowflakeConnectorDTO.getToken())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Password or OAuth token must be set");
        }
        if (!Strings.isNullOrEmpty((String)featurestoreSnowflakeConnectorDTO.getPassword()) && !Strings.isNullOrEmpty((String)featurestoreSnowflakeConnectorDTO.getToken())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Only one authentication method is allowed");
        }
    }
}

