/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.hosts;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.api.ResourceRequest;
import io.hops.hopsworks.common.dao.host.HostDTO;
import io.hops.hopsworks.common.dao.host.HostsFacade;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.host.Hosts;
import io.hops.hopsworks.restutils.RESTCodes;
import java.net.URI;
import java.util.Optional;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class HostsController {
    @EJB
    private HostsFacade hostsFacade;

    public Hosts findByHostname(String hostname) throws ServiceException {
        Optional<Hosts> optional = this.hostsFacade.findByHostname(hostname);
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new ServiceException(RESTCodes.ServiceErrorCode.HOST_NOT_FOUND, Level.WARNING, "hostname: " + hostname);
    }

    public boolean removeByHostname(String hostname) {
        if (hostname == null) {
            throw new IllegalArgumentException("Hostname was not provided");
        }
        Optional<Hosts> optional = this.hostsFacade.findByHostname(hostname);
        if (optional.isPresent()) {
            this.hostsFacade.remove(optional.get());
            return true;
        }
        return false;
    }

    public Response addOrUpdateClusterNode(UriInfo uriInfo, String hostname, HostDTO updateNode) {
        Optional<Hosts> optional = this.hostsFacade.findByHostname(hostname);
        if (optional.isPresent()) {
            return this.updateExistingClusterNode(optional.get(), updateNode);
        }
        Hosts finalNode = this.createNewClusterNode(hostname, updateNode);
        URI uri = uriInfo.getBaseUriBuilder().path(ResourceRequest.Name.HOSTS.toString()).path(finalNode.getHostname()).build(new Object[0]);
        return Response.created((URI)uri).entity((Object)finalNode).build();
    }

    public void addOrUpdateClusterNode(String hostname, HostDTO updateNode) {
        Optional<Hosts> optional = this.hostsFacade.findByHostname(hostname);
        if (optional.isPresent()) {
            this.updateExistingClusterNode(optional.get(), updateNode);
        } else {
            this.createNewClusterNode(hostname, updateNode);
        }
    }

    private Hosts createNewClusterNode(String hostname, HostDTO updateNode) {
        if (Strings.isNullOrEmpty((String)updateNode.getHostname())) {
            throw new IllegalArgumentException("Hostname was not provided");
        }
        if (Strings.isNullOrEmpty((String)updateNode.getHostIp())) {
            throw new IllegalArgumentException("Host ip was not provided");
        }
        if (updateNode.getNumGpus() == null) {
            updateNode.setNumGpus(0);
        }
        Hosts finalNode = new Hosts();
        finalNode.setHostname(updateNode.getHostname());
        finalNode.setHostIp(updateNode.getHostIp());
        finalNode.setNumGpus(updateNode.getNumGpus());
        this.hostsFacade.save(finalNode);
        return finalNode;
    }

    private Response updateExistingClusterNode(Hosts storedNode, HostDTO updateNode) {
        if (updateNode.getHostIp() != null && !updateNode.getHostIp().isEmpty()) {
            storedNode.setHostIp(updateNode.getHostIp());
        }
        if (updateNode.getPublicIp() != null && !updateNode.getPublicIp().isEmpty()) {
            storedNode.setPublicIp(updateNode.getPublicIp());
        }
        if (updateNode.getPrivateIp() != null && !updateNode.getPrivateIp().isEmpty()) {
            storedNode.setPrivateIp(updateNode.getPrivateIp());
        }
        if (updateNode.getAgentPassword() != null && !updateNode.getAgentPassword().isEmpty()) {
            storedNode.setAgentPassword(updateNode.getAgentPassword());
        }
        this.hostsFacade.update(storedNode);
        return Response.noContent().build();
    }
}

