/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import io.hops.hopsworks.common.util.Ip;
import java.util.ArrayList;
import java.util.List;

public class OpenSearchSettings {
    public static final String OPENSEARCH_IP_DEFAULT = "127.0.0.1";
    public static final int OPENSEARCH_PORT_DEFAULT = 9300;
    public static final int OPENSEARCH_REST_PORT_DEFAULT = 9200;
    public static final boolean OPENSEARCH_SECURTIY_ENABLED_DEFAULT = false;
    public static final boolean OPENSEARCH_HTTPS_ENABLED_DEFAULT = false;
    public static final String OPENSEARCH_ADMIN_USER_DEFAULT = "admin";
    public static final String OPENSEARCH_ADMIN_SERVICE_LOG_USER_DEFAULT = "service_log_viewer";
    public static final String OPENSEARCH_ADMIN_PASSWORD_DEFAULT = "adminpw";
    public static final boolean OPENSEARCH_JWT_ENABLED_DEFAULT = false;
    public static final String OPENSEARCH_JWT_URL_PARAMETER_DEFAULT = "jt";
    public static final long OPENSEARCH_JWT_EXP_MS_DEFAULT = 600000L;
    public static final String OPENSEARCH_ADMIN_ROLE = "admin";
    public static final String OPENSEARCH_SERVICE_LOG_ROLE = "service_log_viewer";
    public static final Integer DEFAULT_SCROLL_PAGE_SIZE = 1000;
    public static final Integer MAX_SCROLL_PAGE_SIZE = 10000;
    private final List<String> openSearchIps;
    private final int openSearchPort;
    private final int openSearchRestPort;
    private final boolean openSearchSecurityEnabled;
    private final boolean httpsEnabled;
    private final String adminUser;
    private final String adminPassword;
    private final boolean openSearchJWTEnabled;
    private final String openSearchJWTURLParameter;
    private final long openSearchJWTExpMs;
    private final String serviceLogUser;
    private int rrIndex = 0;

    public OpenSearchSettings(String openSearchIps, int openSearchPort, int openSearchRestPort, boolean openSearchSecurityEnabled, boolean httpsEnabled, String adminUser, String adminPassword, boolean openSearchJWTEnabled, String openSearchJWTURLParameter, long openSearchJWTExpMs, String serviceLogUser) {
        String[] ips = openSearchIps.split(",");
        ArrayList<String> validIps = new ArrayList<String>();
        for (String ip : ips) {
            if (!Ip.validIp(ip)) continue;
            validIps.add(ip);
        }
        this.openSearchIps = validIps;
        this.openSearchPort = openSearchPort;
        this.openSearchRestPort = openSearchRestPort;
        this.openSearchSecurityEnabled = openSearchSecurityEnabled;
        this.httpsEnabled = httpsEnabled;
        this.adminUser = adminUser;
        this.adminPassword = adminPassword;
        this.openSearchJWTEnabled = openSearchJWTEnabled;
        this.openSearchJWTURLParameter = openSearchJWTURLParameter;
        this.openSearchJWTExpMs = openSearchJWTExpMs;
        this.serviceLogUser = serviceLogUser;
    }

    public List<String> getOpenSearchIps() {
        return this.openSearchIps;
    }

    public String getOpenSearchEndpoint() {
        return this.getOpenSearchIp() + ":" + this.openSearchPort;
    }

    public String getOpenSearchRESTEndpoint() {
        return (this.isHttpsEnabled() ? "https" : "http") + "://" + this.getOpenSearchIp() + ":" + this.openSearchRestPort;
    }

    public int getOpenSearchPort() {
        return this.openSearchPort;
    }

    public int getOpenSearchRESTPort() {
        return this.openSearchRestPort;
    }

    private String getOpenSearchIp() {
        if (this.rrIndex == this.openSearchIps.size()) {
            this.rrIndex = 0;
        }
        return this.openSearchIps.get(this.rrIndex++);
    }

    public boolean isOpenSearchSecurityEnabled() {
        return this.openSearchSecurityEnabled;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    public String getAdminUser() {
        return this.adminUser;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public boolean isOpenSearchJWTEnabled() {
        return this.openSearchJWTEnabled;
    }

    public String getOpenSearchJWTURLParameter() {
        return this.openSearchJWTURLParameter;
    }

    public long getOpenSearchJWTExpMs() {
        return this.openSearchJWTExpMs;
    }

    public Integer getDefaultScrollPageSize() {
        return DEFAULT_SCROLL_PAGE_SIZE;
    }

    public Integer getMaxScrollPageSize() {
        return MAX_SCROLL_PAGE_SIZE;
    }

    public String getServiceLogUser() {
        return this.serviceLogUser;
    }
}

