/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.user.security.ua;

import io.hops.hopsworks.persistence.entity.user.security.apiKey.ApiScope;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class UserAccountsEmailMessages {
    public static final String ACCOUNT_REQUEST_SUBJECT = "Your Hopsworks account needs verification";
    public static final String ACCOUNT_CONFIRMATION_SUBJECT = "Welcome to Hopsworks!";
    public static final String ACCOUNT_BLOCKED__SUBJECT = "Your account is locked";
    public static final String ACCOUNT_PASSWORD_RECOVERY_SUBJECT = "You have requested to recover your password";
    public static final String ACCOUNT_MOBILE_RECOVERY_SUBJECT = "You have requested to recover a lost device";
    public static final String ACCOUNT_PASSWORD_RESET = "Your password has been reset";
    public static final String ACCOUNT_QR_RESET = "Your QR code has been reset";
    public static final String ACCOUNT_REJECT = "Your Hopsworks account request has been rejected";
    public static final String ACCOUNT_STATUS_CHANGED = "Your Hopsworks account status was changed";
    public static final int ACCOUNT_ACTIVATION_PERIOD = 48;
    public static final String GREETINGS_HEADER = "Hello";
    public static final String API_KEY_CREATED_SUBJECT = "Api key created";
    public static final String API_KEY_DELETED_SUBJECT = "Api key deleted";

    @Deprecated
    public static String buildMobileRequestMessage(String path, String key) {
        String l1 = "Hello,\n\nWe received an account request for Hopsworks on your behalf.\n\n";
        String l2 = "Please click on the following link to verify your email address. We will activate your account within 48 hours after validating your email address.\n\n\n";
        String url = path + "/hopsworks-admin/security/validate_account.xhtml?key=" + key;
        String l3 = "To confirm your email click " + url + " \n\n";
        String l4 = "If you have any questions please visit https://community.hopsworks.ai/";
        String message = l1 + l2 + l3 + l4;
        return message;
    }

    public static String buildMobileRequestMessageRest(String path, String key, long validFor) {
        String l1 = "Hello,\n\nWe received an account request for Hopsworks on your behalf.\n\n";
        String l2 = "Please click on the following link to verify your email address. We will activate your account within 48 hours after validating your email address.\n\n\n";
        String url = path + "?key=" + key;
        String l3 = "To confirm your email click " + url + " \n\n";
        String l4 = "If you did not request an account, please ignore this email. This link is only valid for" + UserAccountsEmailMessages.formatTime(validFor) + ". \n\n";
        String l5 = "If you have any questions please visit https://community.hopsworks.ai/";
        String message = l1 + l2 + l3 + l4 + l5;
        return message;
    }

    public static String buildPasswordRecoveryMessage(String path, String key, long validFor) {
        String l1 = "Hello,\n\n We received a password recovery request for Hopsworks on your behalf.\n\n";
        String l2 = "Please click on the following link to recover your password: \n";
        String url = path + "/hopsworks/#!/passwordRecovery?key=" + key;
        String l3 = url + " \n\n";
        String l4 = "If you did not request a password reset, please ignore this email. This password reset link is only valid for " + UserAccountsEmailMessages.formatTime(validFor) + ". \n\n";
        String l5 = "If you have any questions please visit https://community.hopsworks.ai/";
        String message = l1 + l2 + l3 + l4 + l5;
        return message;
    }

    public static String buildQRRecoveryMessage(String path, String key, long validFor) {
        String l1 = "Hello,\n\n We received a lost mobile recovery request for Hopsworks on your behalf.\n\n";
        String l2 = "Please click on the following link to recover your QR code: \n";
        String url = path + "/hopsworks/#!/qrRecovery?key=" + key;
        String l3 = url + " \n\n";
        String l4 = "If you did not request a QR code reset, please ignore this email. This QR code reset link is only valid for " + UserAccountsEmailMessages.formatTime(validFor) + ". \n\n";
        String l5 = "If you have any questions please visit https://community.hopsworks.ai/";
        String message = l1 + l2 + l3 + l4 + l5;
        return message;
    }

    public static String formatTime(long validForMs) {
        long hh = TimeUnit.MILLISECONDS.toHours(validForMs);
        long mm = TimeUnit.MILLISECONDS.toMinutes(validForMs) % 60L;
        StringBuilder validFor = new StringBuilder();
        if (hh > 0L) {
            validFor.append(hh).append(hh == 1L ? " hour" : " hours");
        }
        if (hh > 0L && mm > 0L) {
            validFor.append(" and ").append(mm).append(mm == 1L ? " minute" : " minutes");
        } else if (mm > 0L) {
            validFor.append(mm).append(mm == 1L ? " minute" : " minutes");
        }
        return validFor.toString();
    }

    public static String accountBlockedMessage() {
        String l1 = "Hello,\n\nYour Hopsworks account has been blocked.\n\n";
        String l2 = "If you have any questions please visit www.hops.io or contact support@hops.io";
        String l3 = "If you have any questions please visit https://community.hopsworks.ai/";
        String message = l1 + l2 + l3;
        return message;
    }

    public static String buildResetMessage() {
        String l1 = "Hello,\n\nA password reset has been requested on your behalf.\n\n";
        String l2 = "Your password has been changed successfully.\n\n\n";
        String l3 = "If you have any questions please visit https://community.hopsworks.ai/";
        String message = l1 + l2 + l3;
        return message;
    }

    public static String buildResetByAdminMessage(String initiator) {
        String l1 = "Hello,\n\nYour password was reset by a platform administrator (" + initiator + ").\n\n";
        String l2 = "Your password has been changed successfully.\n\n\n";
        String l3 = "If you have any questions please visit https://community.hopsworks.ai/";
        String message = l1 + l2 + l3;
        return message;
    }

    public static String buildQRResetMessage() {
        String l1 = "Hello,\n\n A lost device has been reported on Hopsworks.\n\n";
        String l2 = "Your QR code has been changed successfully.\n\n\n";
        String l3 = "If you have any questions please visit https://community.hopsworks.ai/";
        String message = l1 + l2 + l3;
        return message;
    }

    public static String accountActivatedMessage(String username) {
        String l1 = "Hello,\n\nYour account request to access Hopsworks has been approved.\n\n";
        String l2 = "You can login with your username: " + username + " and other credentials you setup.\n\n\n";
        String l3 = "If you have any questions please visit https://community.hopsworks.ai/";
        String message = l1 + l2 + l3;
        return message;
    }

    public static String accountRejectedMessage() {
        String l1 = "Hello,\n\nYour Hopsworks account request has been rejected.\n\n";
        String l2 = "If you have any questions please visit https://community.hopsworks.ai/";
        String message = l1 + l2;
        return message;
    }

    public static String accountStatusChangeMessage(String status) {
        String l1 = "Hello,\n\nYour Hopsworks account status was changed to " + status + ".\n\n";
        String l2 = "If you have any questions please visit https://community.hopsworks.ai/";
        String message = l1 + l2;
        return message;
    }

    public static String buildClusterRegisterRequestMessage(String path, String key) {
        String l1 = "Hello,\n\nWe received an account request for Hopsworks on your behalf.\n\n";
        String l2 = "Please click on the following link to verify your email address. Within48 hours of getting this email.\n\n\n";
        String url = path + "/hopsworks-cluster/api/cluster/register/confirm/" + key;
        String l3 = "To confirm your email click " + url + " \n\n";
        String l4 = "If you have any questions please visit https://community.hopsworks.ai/";
        String message = l1 + l2 + l3 + l4;
        return message;
    }

    public static String buildClusterUnregisterRequestMessage(String path, String key) {
        String l1 = "Hello,\n\nWe received a cluster remove request for Hops.site on your behalf.\n\n";
        String l2 = "Please click on the link below to verify your email address. Within48 hours of getting this email.\n\n\n";
        String url = path + "/hopsworks-cluster/api/cluster/unregister/confirm/" + key;
        String l3 = "To confirm this request click " + url + " \n\n";
        String l4 = "If you have any questions please visit https://community.hopsworks.ai/";
        String message = l1 + l2 + l3 + l4;
        return message;
    }

    public static String buildApiKeyCreatedMessage(String keyName, Date createdOn, String email, Set<ApiScope> scopes) {
        String l1 = "Hello,\n\nYou have successfully created an api key for your Hopsworks Account " + email + " named \"" + keyName + "\" on " + createdOn + ".\nThis api key will allow you to access your Hopsworks account from a device or application that can not login with a username and password. Attaching this api key on a request authentication header will allow you to access any hopsworks service in the scope: " + scopes + ".\n";
        String l2 = "Don't recognize this activity? please contact your administrator";
        String message = l1 + l2;
        return message;
    }

    public static String buildApiKeyDeletedMessage(String keyName, Date deletedOn, String email) {
        String l1 = "Hello,\n\nYou have deleted an api key created for your Hopsworks Account " + email + " named \"" + keyName + "\" on " + deletedOn + ".\n";
        String l2 = "Don't recognize this activity? please contact your administrator";
        String message = l1 + l2;
        return message;
    }

    public static String buildApiKeyDeletedAllMessage(Date deletedOn, String email) {
        String l1 = "Hello,\n\nYou have deleted all api keys created for your Hopsworks Account " + email + " on " + deletedOn + ".\n";
        String l2 = "Don't recognize this activity? please contact your administrator";
        String message = l1 + l2;
        return message;
    }
}

