/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.api;

import io.hops.hopsworks.common.api.ResourceRequest;
import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class CollectionsBuilder<T> {
    protected abstract List<T> getAll(Project var1);

    protected abstract List<T> filterTopics(List<T> var1, AbstractFacade.FilterBy var2);

    protected abstract List<T> sortTopics(List<T> var1, Set<? extends AbstractFacade.SortBy> var2);

    public List<T> buildItems(Project project, ResourceRequest resourceRequest) {
        List<T> list = this.getAll(project);
        for (AbstractFacade.FilterBy filterBy : resourceRequest.getFilter()) {
            list = this.filterTopics(list, filterBy);
        }
        list = this.sortTopics(list, resourceRequest.getSort());
        list = this.paginate(list, resourceRequest.getLimit(), resourceRequest.getOffset());
        return list;
    }

    private List<T> paginate(List<T> list, Integer limit, Integer offset) {
        Stream stream = list.stream();
        if (offset != null && offset > 0) {
            stream = stream.skip(offset.intValue());
        }
        if (limit != null && limit > 0) {
            stream = stream.limit(limit.intValue());
        }
        return stream.collect(Collectors.toList());
    }
}

