/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dataset.util;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.fs.Path;

public class CompressionInfo {
    private Path hdfsPath;
    private Path outputPath;
    private String stagingDirectory;

    public CompressionInfo(Path hdfsPath, Path outputPath) {
        this.hdfsPath = hdfsPath;
        this.outputPath = outputPath;
        if (outputPath != null) {
            this.setStagingDirectory(DigestUtils.sha256Hex((String)(hdfsPath.toString() + "_" + outputPath.toString())));
        } else {
            this.setStagingDirectory(DigestUtils.sha256Hex((String)hdfsPath.toString()));
        }
    }

    public Path getHdfsPath() {
        return this.hdfsPath;
    }

    public void setHdfsPath(Path hdfsPath) {
        this.hdfsPath = hdfsPath;
    }

    public Path getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(Path outputPath) {
        this.outputPath = outputPath;
    }

    public String getStagingDirectory() {
        return this.stagingDirectory;
    }

    public void setStagingDirectory(String stagingDirectory) {
        this.stagingDirectory = stagingDirectory;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompressionInfo)) {
            return false;
        }
        CompressionInfo cinfo = (CompressionInfo)obj;
        return this.hdfsPath.equals((Object)cinfo.hdfsPath);
    }
}

