/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretPlaintext;
import io.hops.hopsworks.common.featurestore.OptionDTO;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnectorType;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.secrets.Secret;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.json.JSONArray;
import org.json.JSONObject;

@Stateless
public class StorageConnectorUtil {
    @EJB
    private SecretsController secretsController;
    @EJB
    private UserFacade userFacade;
    private ObjectMapper objectMapper = new ObjectMapper();

    public String createSecretName(Integer featurestoreId, String connectorName, FeaturestoreConnectorType connectorType) {
        return connectorType.toString().toLowerCase() + "_" + connectorName.replaceAll(" ", "_").toLowerCase() + "_" + featurestoreId;
    }

    public <T> T getSecret(Secret secret, Class<T> valueType) throws FeaturestoreException {
        Object secretClass = null;
        if (secret != null) {
            try {
                Users owner = (Users)this.userFacade.find(secret.getId().getUid());
                SecretPlaintext plainText = this.secretsController.getShared(owner, owner, secret.getId().getName());
                secretClass = valueType == String.class ? plainText.getPlaintext() : this.objectMapper.readValue(plainText.getPlaintext(), valueType);
            }
            catch (ProjectException | ServiceException | UserException | IOException e) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.STORAGE_CONNECTOR_GET_ERROR, Level.FINE, "Unable to retrieve Secret " + secret.getId().getName() + " for this storage connector.", e.getMessage());
            }
        }
        return (T)secretClass;
    }

    public <T> Secret createProjectSecret(Users user, String secretName, Featurestore featureStore, T secretClass) throws ProjectException, UserException {
        if (secretClass != null) {
            String jsonSecretString = this.serializeSecretClass(secretClass);
            return this.secretsController.createSecretForProject(user, secretName, jsonSecretString, featureStore.getProject().getId());
        }
        return null;
    }

    public <T> Secret updateProjectSecret(Users user, Secret secret, String secretName, Featurestore featureStore, T secretClass) throws ProjectException, UserException {
        if (secretClass != null && secret != null) {
            this.secretsController.checkCanAccessSecret(secret, user);
            try {
                secret.setSecret(this.secretsController.encryptSecret(this.serializeSecretClass(secretClass)));
            }
            catch (IOException | GeneralSecurityException e) {
                throw new UserException(RESTCodes.UserErrorCode.SECRET_ENCRYPTION_ERROR, Level.SEVERE, "Error encrypting secret", "Could not encrypt Secret " + secret.getId().getName(), (Throwable)e);
            }
            return secret;
        }
        if (secretClass != null) {
            return this.createProjectSecret(user, secretName, featureStore, secretClass);
        }
        return null;
    }

    public <T> String serializeSecretClass(T secretClass) {
        if (secretClass.getClass() == String.class) {
            return (String)secretClass;
        }
        return new JSONObject(secretClass).toString();
    }

    public List<OptionDTO> toOptions(String arguments) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)arguments)) {
            return null;
        }
        try {
            OptionDTO[] optionArray = (OptionDTO[])this.objectMapper.readValue(arguments, OptionDTO[].class);
            return Arrays.asList(optionArray);
        }
        catch (JsonProcessingException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.STORAGE_CONNECTOR_GET_ERROR, Level.SEVERE, "Error deserializing options list provided with connector", e.getMessage());
        }
    }

    public String fromOptions(List<OptionDTO> options) {
        if (options == null || options.isEmpty()) {
            return null;
        }
        return new JSONArray(options).toString();
    }

    public boolean shouldUpdate(String oldVal, String newVal) {
        return oldVal == null && newVal != null || oldVal != null && !oldVal.equals(newVal);
    }

    public boolean shouldUpdate(Integer oldVal, Integer newVal) {
        return oldVal == null && newVal != null || oldVal != null && !oldVal.equals(newVal);
    }

    public boolean isNullOrWhitespace(String val) {
        return Strings.isNullOrEmpty((String)val) || Strings.isNullOrEmpty((String)val.trim());
    }

    public String getValueOrNull(String val) {
        return this.isNullOrWhitespace(val) ? null : val.trim();
    }
}

