/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.trainingdatasets.hopsfs;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.service.Service;
import io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs.FeaturestoreHopsfsConnectorDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetDTO;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.hopsfs.HopsfsTrainingDataset;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class HopsfsTrainingDatasetController {
    @EJB
    private InodeController inodeController;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;

    public TrainingDatasetDTO convertHopsfsTrainingDatasetToDTO(TrainingDatasetDTO trainingDatasetDTO, TrainingDataset trainingDataset) throws ServiceException {
        Service namenodeService;
        try {
            namenodeService = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(ServiceDiscoveryController.HopsworksService.RPC_NAMENODE);
        }
        catch (ServiceDiscoveryException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.SERVICE_NOT_FOUND, Level.SEVERE, "Could not find namenode service", e.getMessage(), (Throwable)e);
        }
        HopsfsTrainingDataset hopsfsTrainingDataset = trainingDataset.getHopsfsTrainingDataset();
        if (hopsfsTrainingDataset != null) {
            trainingDatasetDTO.setLocation(new Path("hopsfs", namenodeService.getAddress() + ":" + namenodeService.getPort(), this.inodeController.getPath(hopsfsTrainingDataset.getInode())).toString());
            trainingDatasetDTO.setInodeId(hopsfsTrainingDataset.getInode().getId());
            FeaturestoreHopsfsConnectorDTO hopsfsConnectorDTO = new FeaturestoreHopsfsConnectorDTO(hopsfsTrainingDataset.getFeaturestoreConnector());
            trainingDatasetDTO.setStorageConnector(hopsfsConnectorDTO);
        }
        return trainingDatasetDTO;
    }
}

