/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.stream;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.hive.HivePartitions;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.hive.HiveTbls;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.stream.StreamFeatureGroup;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.validation.ConstraintViolationException;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class StreamFeatureGroupFacade
extends AbstractFacade<StreamFeatureGroup> {
    private static final Logger LOGGER = Logger.getLogger(StreamFeatureGroupFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public StreamFeatureGroupFacade() {
        super(StreamFeatureGroup.class);
    }

    public void persist(StreamFeatureGroup streamFeatureGroup) {
        try {
            this.em.persist((Object)streamFeatureGroup);
            this.em.flush();
        }
        catch (ConstraintViolationException cve) {
            LOGGER.log(Level.WARNING, "Could not persist the new stream feature group", cve);
            throw cve;
        }
    }

    public Optional<HiveTbls> getHiveTableByNameAndDB(String hiveTableName, Long hiveDbId) {
        try {
            return Optional.of(this.em.createNamedQuery("HiveTable.findByNameAndDbId", HiveTbls.class).setParameter("name", (Object)hiveTableName.toLowerCase()).setParameter("dbId", (Object)hiveDbId).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<HiveTbls> getHiveTable(Long hiveTableId) {
        try {
            return Optional.of(this.em.createNamedQuery("HiveTable.findById", HiveTbls.class).setParameter("id", (Object)hiveTableId).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public StreamFeatureGroup updateMetadata(StreamFeatureGroup streamFeatureGroup) {
        this.em.merge((Object)streamFeatureGroup);
        return streamFeatureGroup;
    }

    public List<HivePartitions> getHiveTablePartitions(HiveTbls hiveTbls, Integer limit, Integer offset) {
        TypedQuery q = this.em.createNamedQuery("Partitions.findByTbl", HivePartitions.class).setParameter("tbls", (Object)hiveTbls);
        if (offset != null && offset > 0) {
            q.setFirstResult(offset.intValue());
        }
        if (limit != null && limit > 0) {
            q.setMaxResults(limit.intValue());
        }
        return q.getResultList();
    }
}

