/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.serving.inference;

public enum InferenceVerb {
    PREDICT("predict"),
    CLASSIFY("classify"),
    REGRESS("regress"),
    TEST("test");

    private static final String PREFIX = ":";
    private static final String PREDICT_VERB = "predict";
    private static final String CLASSIFY_VERB = "classify";
    private static final String REGRESS_VERB = "regress";
    private static final String TEST_VERB = "test";
    private String verb;
    public static final String ANNOTATION = ":predict|:classify|:regress|:test";

    private InferenceVerb(String verb) {
        this.verb = verb;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean withPrefix) {
        return withPrefix ? PREFIX + this.verb : this.verb;
    }

    public static InferenceVerb fromString(String verb) {
        switch (verb) {
            case ":predict": 
            case "predict": {
                return PREDICT;
            }
            case ":classify": 
            case "classify": {
                return CLASSIFY;
            }
            case ":regress": 
            case "regress": {
                return REGRESS;
            }
            case ":test": 
            case "test": {
                return TEST;
            }
        }
        throw new IllegalArgumentException("unknown inference verb:" + verb);
    }
}

