/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.serving.inference;

import io.hops.common.Pair;
import io.hops.hopsworks.common.integrations.LocalhostStereotype;
import io.hops.hopsworks.common.serving.inference.InferenceEndpoint;
import io.hops.hopsworks.common.serving.inference.InferenceHttpClient;
import io.hops.hopsworks.common.serving.inference.InferencePort;
import io.hops.hopsworks.common.serving.inference.InferenceVerb;
import io.hops.hopsworks.common.serving.inference.LocalhostSkLearnInferenceUtils;
import io.hops.hopsworks.common.serving.inference.LocalhostTfInferenceUtils;
import io.hops.hopsworks.common.serving.inference.ServingInferenceController;
import io.hops.hopsworks.common.serving.inference.ServingInferenceUtils;
import io.hops.hopsworks.exceptions.InferenceException;
import io.hops.hopsworks.persistence.entity.serving.ModelServer;
import io.hops.hopsworks.persistence.entity.serving.Serving;
import io.hops.hopsworks.restutils.RESTCodes;
import java.net.URISyntaxException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;

@LocalhostStereotype
@Singleton
@TransactionAttribute(value=TransactionAttributeType.NEVER)
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class LocalhostInferenceController
implements ServingInferenceController {
    @EJB
    private InferenceHttpClient inferenceHttpClient;
    @EJB
    private LocalhostTfInferenceUtils localhostTfInferenceUtils;
    @EJB
    private LocalhostSkLearnInferenceUtils localhostSkLearnInferenceUtils;
    @EJB
    private ServingInferenceUtils servingInferenceUtils;

    @Override
    public Pair<Integer, String> infer(String username, Serving serving, Integer modelVersion, InferenceVerb verb, String inferenceRequestJson, String authHeader) throws InferenceException {
        if (serving.getCid().equals("stopped")) {
            throw new InferenceException(RESTCodes.InferenceErrorCode.SERVING_NOT_RUNNING, Level.FINE);
        }
        String path = this.getInferencePath(serving, modelVersion, verb);
        InferenceEndpoint endpoint = this.getNodeInferenceEndpoint();
        String host = endpoint.getAnyHost();
        Integer port = serving.getLocalPort();
        try {
            HttpPost request = this.servingInferenceUtils.buildInferenceRequest(host, port, path, inferenceRequestJson);
            HttpClientContext context = HttpClientContext.create();
            CloseableHttpResponse response = this.inferenceHttpClient.execute(request, (HttpContext)context);
            return this.inferenceHttpClient.handleInferenceResponse(response);
        }
        catch (URISyntaxException e) {
            throw new InferenceException(RESTCodes.InferenceErrorCode.REQUEST_ERROR, Level.SEVERE, null, e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedCharsetException e) {
            throw new InferenceException(RESTCodes.InferenceErrorCode.BAD_REQUEST, Level.INFO, null, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<InferenceEndpoint> getInferenceEndpoints() {
        InferenceEndpoint endpoint = this.getNodeInferenceEndpoint();
        return Collections.singletonList(endpoint);
    }

    private InferenceEndpoint getNodeInferenceEndpoint() {
        List<String> hosts = Collections.singletonList("localhost");
        List<InferencePort> ports = Collections.singletonList(new InferencePort(InferencePort.InferencePortName.HTTP, null));
        return new InferenceEndpoint(InferenceEndpoint.InferenceEndpointType.NODE, hosts, ports);
    }

    private String getInferencePath(Serving serving, Integer modelVersion, InferenceVerb verb) {
        if (serving.getModelServer() == ModelServer.TENSORFLOW_SERVING) {
            return this.localhostTfInferenceUtils.getPath(serving.getName(), modelVersion, verb);
        }
        if (serving.getModelServer() == ModelServer.PYTHON) {
            return this.localhostSkLearnInferenceUtils.getPath(verb);
        }
        throw new UnsupportedOperationException("Model server not supported as local serving");
    }
}

