/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.serving;

import io.hops.hopsworks.exceptions.ServingException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.serving.Serving;
import io.hops.hopsworks.restutils.RESTCodes;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.LockTimeoutException;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;

@Stateless
public class ServingFacade {
    private static final Logger LOGGER = Logger.getLogger(ServingFacade.class.getName());
    private static final long LOCK_TIMEOUT = 60000L;
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    private String nodeIP = null;

    @PostConstruct
    private void init() {
        try {
            this.nodeIP = Inet4Address.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.log(Level.SEVERE, "Could not get host address", e);
        }
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public List<Serving> findForProject(Project project) {
        return this.em.createNamedQuery("Serving.findByProject", Serving.class).setParameter("project", (Object)project).getResultList();
    }

    public List<Serving> findForProjectAndModel(Project project, String modelName) {
        return this.em.createNamedQuery("Serving.findByProjectAndModel", Serving.class).setParameter("project", (Object)project).setParameter("modelName", (Object)modelName).getResultList();
    }

    public Serving findById(Integer id) {
        return (Serving)this.em.createNamedQuery("Serving.findById", Serving.class).setParameter("id", (Object)id).getSingleResult();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void delete(Serving serving) {
        Serving refetched = (Serving)this.em.find(Serving.class, (Object)serving.getId());
        if (refetched != null) {
            this.em.remove((Object)refetched);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Serving updateDbObject(Serving newServing, Project project) throws ServingException {
        Serving oldDbServing = this.findByProjectAndId(project, newServing.getId());
        Serving dbServing = this.mergeServings(oldDbServing, newServing);
        return this.merge(dbServing);
    }

    public Serving mergeServings(Serving dbServing, Serving newServing) {
        if (newServing.getName() != null && !newServing.getName().isEmpty()) {
            dbServing.setName(newServing.getName());
        }
        if (newServing.getDescription() != null && !newServing.getDescription().isEmpty()) {
            dbServing.setDescription(newServing.getDescription());
        }
        if (newServing.getModelPath() != null && !newServing.getModelPath().isEmpty()) {
            dbServing.setModelPath(newServing.getModelPath());
        }
        if (newServing.getInstances() != null) {
            dbServing.setInstances(newServing.getInstances());
        }
        if (newServing.getModelName() != null) {
            dbServing.setModelName(newServing.getModelName());
        }
        if (newServing.getModelVersion() != null) {
            dbServing.setModelVersion(newServing.getModelVersion());
        }
        dbServing.setKafkaTopic(newServing.getKafkaTopic());
        if (newServing.getCid() != null) {
            dbServing.setCid(newServing.getCid());
        }
        if (newServing.getLocalDir() != null) {
            dbServing.setLocalDir(newServing.getLocalDir());
        }
        if (newServing.getLocalPort() != null) {
            dbServing.setLocalPort(newServing.getLocalPort());
        }
        if (newServing.getBatchingConfiguration() != null) {
            dbServing.setBatchingConfiguration(newServing.getBatchingConfiguration());
        }
        if (newServing.getServingTool() != null) {
            dbServing.setServingTool(newServing.getServingTool());
        }
        dbServing.setDeployed(newServing.getDeployed());
        return dbServing;
    }

    public Serving fill(Serving serving, Serving dbServing) {
        if (serving.getCreated() == null) {
            serving.setCreated(dbServing.getCreated());
        }
        if (serving.getCreator() == null) {
            serving.setCreator(dbServing.getCreator());
        }
        if (serving.getProject() == null) {
            serving.setProject(dbServing.getProject());
        }
        serving.setOptimized(dbServing.isOptimized());
        if (serving.getName() == null || serving.getName().isEmpty()) {
            serving.setName(dbServing.getName());
        }
        if (serving.getLocalPort() == null) {
            serving.setLocalPort(dbServing.getLocalPort());
        }
        if (serving.getLocalDir() == null) {
            serving.setLocalDir(dbServing.getLocalDir());
        }
        if (serving.getCid() == null || serving.getCid().isEmpty()) {
            serving.setCid(dbServing.getCid());
        }
        if (serving.getLockIP() == null || serving.getLockIP().isEmpty()) {
            serving.setLockIP(dbServing.getLockIP());
        }
        if (serving.getLockTimestamp() == null) {
            serving.setLockTimestamp(dbServing.getLockTimestamp());
        }
        if (serving.getDeployed() == null) {
            serving.setDeployed(dbServing.getDeployed());
        }
        return serving;
    }

    public Serving merge(Serving serving) {
        serving = (Serving)this.em.merge((Object)serving);
        this.em.flush();
        return serving;
    }

    public Serving findByProjectAndId(Project project, Integer id) {
        try {
            return (Serving)this.em.createNamedQuery("Serving.findByProjectAndId", Serving.class).setParameter("project", (Object)project).setParameter("id", (Object)id).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Serving findByProjectAndName(Project project, String servingName) {
        try {
            return (Serving)this.em.createNamedQuery("Serving.findByProjectAndName", Serving.class).setParameter("project", (Object)project).setParameter("name", (Object)servingName).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Serving acquireLock(Project project, Integer id) throws ServingException {
        int retries = 5;
        if (this.nodeIP == null) {
            throw new ServingException(RESTCodes.ServingErrorCode.LIFECYCLE_ERROR_INT, Level.SEVERE);
        }
        while (retries > 0) {
            try {
                Serving serving = (Serving)this.em.createNamedQuery("Serving.findByProjectAndId", Serving.class).setParameter("project", (Object)project).setParameter("id", (Object)id).setLockMode(LockModeType.PESSIMISTIC_WRITE).getSingleResult();
                if (serving == null) {
                    throw new ServingException(RESTCodes.ServingErrorCode.INSTANCE_NOT_FOUND, Level.WARNING);
                }
                if (serving.getLockIP() != null && serving.getLockTimestamp() > System.currentTimeMillis() - 60000L) {
                    --retries;
                    continue;
                }
                serving.setLockIP(this.nodeIP);
                serving.setLockTimestamp(Long.valueOf(System.currentTimeMillis()));
                return (Serving)this.em.merge((Object)serving);
            }
            catch (LockTimeoutException e) {
                --retries;
            }
        }
        throw new ServingException(RESTCodes.ServingErrorCode.LIFECYCLE_ERROR_INT, Level.FINE, "Instance is busy. Please, try later");
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Serving releaseLock(Project project, Integer id) throws ServingException {
        for (int retries = 5; retries > 0; --retries) {
            try {
                Serving serving = (Serving)this.em.createNamedQuery("Serving.findByProjectAndId", Serving.class).setParameter("project", (Object)project).setParameter("id", (Object)id).setLockMode(LockModeType.PESSIMISTIC_WRITE).getSingleResult();
                serving.setLockIP(null);
                serving.setLockTimestamp(null);
                return (Serving)this.em.merge((Object)serving);
            }
            catch (LockTimeoutException e) {
                continue;
            }
        }
        throw new ServingException(RESTCodes.ServingErrorCode.LIFECYCLE_ERROR_INT, Level.FINE);
    }

    public List<Serving> getLocalhostRunning() {
        return this.em.createNamedQuery("Serving.findLocalhostRunning", Serving.class).getResultList();
    }
}

