/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.erasureCode;

import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.jobs.AsynchronousJobExecutor;
import io.hops.hopsworks.common.jobs.yarn.YarnJob;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.jobs.configuration.erasureCode.ErasureCodeJobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ErasureCodeJob
extends YarnJob {
    private static final Logger logger = Logger.getLogger(ErasureCodeJob.class.getName());
    private ErasureCodeJobConfiguration jobConfig;

    public ErasureCodeJob(Jobs job, AsynchronousJobExecutor services, Users user, String jobUser, String hadoopDir, Settings settings, ServiceDiscoveryController serviceDiscoveryController) {
        super(job, services, user, jobUser, hadoopDir, settings, null, null, null, serviceDiscoveryController);
        if (!(job.getJobConfig() instanceof ErasureCodeJobConfiguration)) {
            throw new IllegalArgumentException("JobDescription must contain an ErasureCodeJobConfiguration object. Received: " + job.getJobConfig().getClass());
        }
        this.jobConfig = (ErasureCodeJobConfiguration)job.getJobConfig();
    }

    @Override
    protected boolean setupJob() {
        if (this.jobConfig.getAppName() == null || this.jobConfig.getAppName().isEmpty()) {
            this.jobConfig.setAppName("Untitled Erasure coding Job");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runJob(String args) {
        boolean jobSucceeded = false;
        try (DistributedFileSystemOps dfso = null;){
            dfso = this.services.getFsService().getDfsOps();
            jobSucceeded = dfso.compress(this.jobConfig.getFilePath());
        }
        if (jobSucceeded) {
            logger.log(Level.INFO, "File compression was successful");
            return;
        }
        logger.log(Level.INFO, "File compression was not successful");
    }

    @Override
    protected void cleanup() {
    }

    @Override
    protected void writeToLogs(String message, Exception e) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void writeToLogs(String message) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

