/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.app.dto;

import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.util.DateUtils;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ProvAppStateDTO {
    private Provenance.AppState currentState;
    private Long submitTime = null;
    private String readableSubmitTime = "";
    private Long startTime = null;
    private String readableStartTime = "";
    private Long finishTime = null;
    private String readableFinishTime = "";

    public static ProvAppStateDTO unknown() {
        ProvAppStateDTO state = new ProvAppStateDTO();
        state.setCurrentState(Provenance.AppState.UNKNOWN);
        return state;
    }

    public Provenance.AppState getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(Provenance.AppState currentState) {
        this.currentState = currentState;
    }

    public Long getSubmitTime() {
        return this.submitTime;
    }

    public void setSubmitTime(Long submitTime) {
        this.submitTime = submitTime;
    }

    public String getReadableSubmitTime() {
        return this.readableSubmitTime;
    }

    public void setReadableSubmitTime(String readableSubmitTime) {
        this.readableSubmitTime = readableSubmitTime;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public String getReadableStartTime() {
        return this.readableStartTime;
    }

    public void setReadableStartTime(String readableStartTime) {
        this.readableStartTime = readableStartTime;
    }

    public Long getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(Long finishTime) {
        this.finishTime = finishTime;
    }

    public String getReadableFinishTime() {
        return this.readableFinishTime;
    }

    public void setReadableFinishTime(String readableFinishTime) {
        this.readableFinishTime = readableFinishTime;
    }

    public void setAppState(Provenance.AppState appState, Long time) throws ProvenanceException {
        switch (appState) {
            case SUBMITTED: {
                this.currentState = Provenance.AppState.SUBMITTED;
                this.submitTime = time;
                this.readableSubmitTime = DateUtils.millis2LocalDateTime(time).toString();
                break;
            }
            case RUNNING: {
                this.currentState = Provenance.AppState.RUNNING;
                this.startTime = time;
                this.readableStartTime = DateUtils.millis2LocalDateTime(time).toString();
                break;
            }
            case FINISHED: 
            case FAILED: 
            case KILLED: {
                this.currentState = appState;
                this.finishTime = time;
                this.readableFinishTime = DateUtils.millis2LocalDateTime(time).toString();
                break;
            }
            default: {
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.WARNING, "unknown app state from opensearch:" + (Object)((Object)appState));
            }
        }
    }
}

