/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.datavalidationv2;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.ExpectationSuite;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.validation.ConstraintViolationException;

@Stateless
public class ExpectationSuiteFacade
extends AbstractFacade<ExpectationSuite> {
    private static final Logger LOGGER = Logger.getLogger(ExpectationSuiteFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public ExpectationSuiteFacade() {
        super(ExpectationSuite.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void persist(ExpectationSuite expectationSuite) {
        try {
            this.em.persist((Object)expectationSuite);
            this.em.flush();
        }
        catch (ConstraintViolationException cve) {
            LOGGER.log(Level.WARNING, "Could not persist the new ExpectationSuite", cve);
        }
    }

    public Optional<ExpectationSuite> findByFeaturegroup(Featuregroup featuregroup) {
        try {
            return Optional.of(this.em.createNamedQuery("ExpectationSuite.findByFeatureGroup", ExpectationSuite.class).setParameter("featureGroup", (Object)featuregroup).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }
}

