/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.git.util;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.git.GitRepositoryFacade;
import io.hops.hopsworks.common.git.BasicAuthSecrets;
import io.hops.hopsworks.common.git.CloneCommandConfiguration;
import io.hops.hopsworks.common.git.CommitCommandConfiguration;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.exceptions.GitOpException;
import io.hops.hopsworks.persistence.entity.git.GitRepository;
import io.hops.hopsworks.persistence.entity.git.config.GitCommandConfiguration;
import io.hops.hopsworks.persistence.entity.git.config.GitCommandType;
import io.hops.hopsworks.persistence.entity.git.config.GitProvider;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class GitCommandConfigurationValidator {
    private static final Logger LOGGER = Logger.getLogger(GitCommandConfigurationValidator.class.getName());
    private static final Pattern REPO_ATTRS = Pattern.compile("http(s)?://(?<type>.+)/(?<username>.+)/(?<repository>.+)\\.git");
    @EJB
    private GitRepositoryFacade gitRepositoryFacade;
    @EJB
    private InodeController inodeController;

    public void verifyCloneOptions(CloneCommandConfiguration config) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)config.getUrl())) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.REPOSITORY_URL_NOT_PROVIDED.getMessage());
        }
        if (config.getProvider() == null) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.GIT_PROVIDER_NOT_PROVIDED.getMessage() + "Invalid git provider. Git provider should be one of GitHub, GitLab, or BitBucket");
        }
        this.verifyRepositoryPath(config.getPath());
    }

    public void verifyCommitOptions(CommitCommandConfiguration commitConfiguration) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)commitConfiguration.getMessage())) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.COMMIT_MESSAGE_IS_EMPTY.getMessage());
        }
        if (!commitConfiguration.isAll().booleanValue() && commitConfiguration.getFiles().isEmpty()) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.COMMIT_FILES_EMPTY.getMessage() + ". Please specify set the all option to true if you want to add and commit all the files.");
        }
    }

    public void verifyRemoteNameAndBranch(String remoteName, String branchName) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)remoteName)) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.INVALID_REMOTE_NAME.getMessage());
        }
        if (Strings.isNullOrEmpty((String)branchName)) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.INVALID_BRANCH_NAME.getMessage());
        }
    }

    public GitRepository verifyRepository(Project project, Integer repositoryId) throws GitOpException, IllegalArgumentException {
        Optional<GitRepository> optional = this.gitRepositoryFacade.findByIdAndProject(project, repositoryId);
        return optional.orElseThrow(() -> new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.REPOSITORY_NOT_FOUND, Level.SEVERE, "No repository with id [" + repositoryId + "] in project [" + project.getId() + "] found in database."));
    }

    private void verifyRepositoryPath(String gitPath) throws IllegalArgumentException {
        Inode inode = this.inodeController.getInodeAtPath(gitPath);
        if (Strings.isNullOrEmpty((String)gitPath)) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.DIRECTORY_PATH_NOT_PROVIDED.getMessage());
        }
        if (inode == null) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.DIRECTORY_PATH_DOES_NOT_EXIST.getMessage());
        }
        if (!inode.isDir()) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.PATH_IS_NOT_DIRECTORY.getMessage());
        }
        if (this.gitRepositoryFacade.findByInode(inode).isPresent()) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.DIRECTORY_IS_ALREADY_GIT_REPO.getMessage());
        }
    }

    public void validateProviderConfiguration(BasicAuthSecrets secrets, GitCommandConfiguration gitCommandConfiguration) throws GitOpException {
        GitCommandType commandType = gitCommandConfiguration.getCommandType();
        GitProvider gitProvider = gitCommandConfiguration.getProvider();
        if (gitProvider == GitProvider.BITBUCKET && (commandType == GitCommandType.PULL || commandType == GitCommandType.PUSH || commandType == GitCommandType.CLONE) && (Strings.isNullOrEmpty((String)secrets.getUsername()) || Strings.isNullOrEmpty((String)secrets.getPassword()))) {
            throw new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.GIT_USERNAME_AND_PASSWORD_NOT_SET, Level.WARNING, ". You should setup secrets for " + gitProvider.getProvider() + " to be able to perform a " + commandType.getGitCommand() + " operation");
        }
        if ((gitProvider == GitProvider.GIT_HUB || gitProvider == GitProvider.GIT_LAB) && commandType == GitCommandType.PUSH && (Strings.isNullOrEmpty((String)secrets.getUsername()) || Strings.isNullOrEmpty((String)secrets.getPassword()))) {
            throw new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.GIT_USERNAME_AND_PASSWORD_NOT_SET, Level.WARNING, ". You should setup secrets for " + gitProvider.getProvider() + " to be able to perform a " + commandType.getGitCommand() + " operation");
        }
    }

    public String getRepositoryName(String remoteURI) throws IllegalArgumentException {
        Matcher matcher = REPO_ATTRS.matcher(remoteURI);
        if (matcher.matches()) {
            return matcher.group("repository");
        }
        throw new IllegalArgumentException("Could not parse remote URI: " + remoteURI);
    }
}

