/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.spark;

import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.jobs.AsynchronousJobExecutor;
import io.hops.hopsworks.common.jobs.spark.SparkYarnRunnerBuilder;
import io.hops.hopsworks.common.jobs.yarn.YarnJob;
import io.hops.hopsworks.common.serving.ServingConfig;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobType;
import io.hops.hopsworks.persistence.entity.jobs.configuration.spark.SparkJobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SparkJob
extends YarnJob {
    private static final Logger LOG = Logger.getLogger(SparkJob.class.getName());
    private SparkYarnRunnerBuilder runnerbuilder;

    SparkJob(Jobs job, AsynchronousJobExecutor services, Users user, String hadoopDir, String jobUser, Settings settings, String kafkaBrokersString, String hopsworksRestEndpoint, ServingConfig servingConfig, ServiceDiscoveryController serviceDiscoveryController) {
        super(job, services, user, jobUser, hadoopDir, settings, kafkaBrokersString, hopsworksRestEndpoint, servingConfig, serviceDiscoveryController);
        if (!(job.getJobConfig() instanceof SparkJobConfiguration)) {
            throw new IllegalArgumentException("JobDescription must contain a SparkJobConfiguration object. Received: " + job.getJobConfig().getClass());
        }
    }

    @Override
    protected boolean setupJob() {
        SparkJobConfiguration jobconfig = (SparkJobConfiguration)this.jobs.getJobConfig();
        if (jobconfig.getAppName() == null || jobconfig.getAppName().isEmpty()) {
            jobconfig.setAppName("Untitled Spark Job");
        }
        if (this.runnerbuilder == null) {
            this.runnerbuilder = new SparkYarnRunnerBuilder(this.jobs);
            this.runnerbuilder.setJobName(jobconfig.getAppName());
        }
        if (jobconfig.getLocalResources() != null) {
            this.runnerbuilder.addExtraFiles(Arrays.asList(jobconfig.getLocalResources()));
        }
        this.runnerbuilder.addExtraFiles(this.projectLocalResources);
        if (this.jobSystemProperties != null && !this.jobSystemProperties.isEmpty()) {
            for (Map.Entry jobSystemProperty : this.jobSystemProperties.entrySet()) {
                this.runnerbuilder.addSystemProperty((String)jobSystemProperty.getKey(), (String)jobSystemProperty.getValue());
            }
        }
        String stdFinalDestination = Utils.getProjectPath(this.jobs.getProject().getName()) + Settings.BaseDataset.LOGS.getName() + "/" + JobType.SPARK.getName();
        this.setStdOutFinalDestination(stdFinalDestination);
        this.setStdErrFinalDestination(stdFinalDestination);
        try {
            this.runner = this.runnerbuilder.getYarnRunner(this.jobs.getProject(), this.jobUser, this.user, this.services, this.services.getFileOperations(this.hdfsUser.getUserName()), this.yarnClient, this.settings, this.kafkaBrokersString, this.hopsworksRestEndpoint, this.servingConfig, this.serviceDiscoveryController);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to create YarnRunner.", e);
            try {
                this.writeToLogs(e.getLocalizedMessage());
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, "Failed to write logs for failed application.", ex);
            }
            return false;
        }
        return true;
    }

    @Override
    protected void cleanup() {
        LOG.log(Level.INFO, "Job finished performing cleanup...");
    }
}

