/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.query.filter;

import java.util.Objects;

public class FilterValue {
    private Integer featureGroupId;
    private String featureGroupAlias;
    private String value;

    public FilterValue(String value) {
        this.value = value;
    }

    public FilterValue(Integer featureGroupId, String featureGroupAlias, String value) {
        this.featureGroupId = featureGroupId;
        this.featureGroupAlias = featureGroupAlias;
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isFeatureValue() {
        return this.featureGroupId != null || this.featureGroupAlias != null;
    }

    public Integer getFeatureGroupId() {
        return this.featureGroupId;
    }

    public String makeSqlValue() {
        return this.featureGroupAlias == null ? this.value : String.format("`%s`.`%s`", this.featureGroupAlias, this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterValue that = (FilterValue)o;
        return Objects.equals(this.featureGroupId, that.featureGroupId) && Objects.equals(this.featureGroupAlias, that.featureGroupAlias) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.featureGroupId, this.featureGroupAlias, this.value);
    }
}

