/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.user;

import io.hops.hopsworks.common.dao.certificates.CertsFacade;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.user.BbcGroupFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.security.audit.AccountAuditFacade;
import io.hops.hopsworks.common.dao.user.security.ua.UserAccountsEmailMessages;
import io.hops.hopsworks.common.security.CertificatesMgmService;
import io.hops.hopsworks.common.security.utils.Secret;
import io.hops.hopsworks.common.security.utils.SecurityUtils;
import io.hops.hopsworks.common.user.PasswordRecovery;
import io.hops.hopsworks.common.user.UserStatusValidator;
import io.hops.hopsworks.common.util.EmailBean;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.HttpUtil;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.certificates.UserCerts;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.BbcGroup;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.ua.UserAccountStatus;
import io.hops.hopsworks.persistence.entity.user.security.ua.UserAccountType;
import io.hops.hopsworks.persistence.entity.user.security.ua.ValidationKeyType;
import io.hops.hopsworks.restutils.RESTCodes;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base32;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class AuthController {
    private static final Logger LOGGER = Logger.getLogger(AuthController.class.getName());
    @EJB
    private UserFacade userFacade;
    @EJB
    private BbcGroupFacade bbcGroupFacade;
    @EJB
    private UserStatusValidator userStatusValidator;
    @EJB
    private Settings settings;
    @EJB
    private EmailBean emailBean;
    @EJB
    private CertsFacade userCertsFacade;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private CertificatesMgmService certificatesMgmService;
    @EJB
    private SecurityUtils securityUtils;
    @EJB
    private AccountAuditFacade accountAuditFacade;
    @Inject
    private PasswordRecovery passwordRecovery;
    private static final long RESET_LINK_IN_HOURS = TimeUnit.HOURS.toMillis(24L);

    private void validateUser(Users user) {
        if (user == null) {
            throw new IllegalArgumentException("User not set.");
        }
        if (!user.getMode().equals((Object)UserAccountType.M_ACCOUNT_TYPE)) {
            throw new IllegalArgumentException("Can not login user with account type: " + user.getMode().toString());
        }
    }

    public String preCustomRealmLoginCheck(Users user, String password, String otp) throws UserException {
        this.validateUser(user);
        if (this.isTwoFactorEnabled(user) && (otp == null || otp.isEmpty()) && user.getMode().equals((Object)UserAccountType.M_ACCOUNT_TYPE) && this.checkPasswordAndStatus(user, password)) {
            throw new IllegalStateException("Second factor required.");
        }
        if (otp == null || otp.isEmpty() && user.getMode().equals((Object)UserAccountType.M_ACCOUNT_TYPE)) {
            otp = "@@@@@@";
        }
        String newPassword = this.getPasswordPlusSalt(password, user.getSalt());
        if (otp.length() != "@@@@@@".length() || !user.getMode().equals((Object)UserAccountType.M_ACCOUNT_TYPE)) {
            throw new IllegalArgumentException("Could not recognize the account type. Report a bug.");
        }
        newPassword = newPassword + otp;
        return newPassword;
    }

    public boolean validatePassword(Users user, String password) {
        this.validateUser(user);
        String userPwdHash = user.getPassword();
        Secret secret = new Secret(password, user.getSalt());
        if (!userPwdHash.equals(secret.getSha256HexDigest())) {
            this.registerFalseLogin(user);
            LOGGER.log(Level.FINEST, "False login attempt by user: {0}", user.getEmail());
            return false;
        }
        this.resetFalseLogin(user);
        return true;
    }

    public boolean checkPasswordAndStatus(Users user, String password) throws UserException {
        if (user == null) {
            throw new IllegalArgumentException("User not set.");
        }
        this.userStatusValidator.checkStatus(user.getStatus());
        return this.validatePassword(user, password);
    }

    public boolean checkUserPasswordAndStatus(Users user, String password) throws UserException {
        this.checkUserStatus(user, false);
        return this.validatePassword(user, password);
    }

    private Users getUserFromKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Validation key not supplied.");
        }
        if (key.length() <= 8) {
            throw new IllegalArgumentException("Unrecognized validation key.");
        }
        String userName = key.substring(0, 8);
        return this.userFacade.findByUsername(userName);
    }

    private void validate(Users user, String key) throws UserException {
        String secret = key.substring(8);
        if (!secret.equals(user.getValidationKey())) {
            this.registerFalseKeyValidation(user);
            throw new UserException(RESTCodes.UserErrorCode.INCORRECT_VALIDATION_KEY, Level.FINE);
        }
        if (this.diffMillis(user.getValidationKeyUpdated()) < TimeUnit.SECONDS.toMillis(5L)) {
            this.resetValidationKey(user);
            throw new UserException(RESTCodes.UserErrorCode.INCORRECT_VALIDATION_KEY, Level.FINE);
        }
        this.resetFalseLogin(user);
    }

    public void validateEmail(String key) throws UserException {
        Users user = this.getUserFromKey(key);
        this.checkUserStatusAndKey(user, ValidationKeyType.EMAIL, true);
        this.validate(user, key);
        user.setStatus(UserAccountStatus.VERIFIED_ACCOUNT);
        user.setActivated((Date)new Timestamp(new Date().getTime()));
        this.resetValidationKey(user);
    }

    public void validateOTP(String email, String password, String otp) throws UserException {
        Users user = this.userFacade.findByEmail(email);
        if (user == null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_DOES_NOT_EXIST, Level.FINE);
        }
        if (this.validatePassword(user, password)) {
            this.validateOTP(user, otp);
        }
    }

    public void validateOTP(Users user, String otpStr) throws UserException {
        int otp;
        try {
            otp = Integer.parseInt(otpStr);
        }
        catch (NumberFormatException e) {
            throw new UserException(RESTCodes.UserErrorCode.INVALID_OTP, Level.FINE, "OTP not an integer");
        }
        if (user == null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_DOES_NOT_EXIST, Level.FINE, "User not found");
        }
        boolean valid = this.checkCode(user.getSecret(), otp);
        if (!valid) {
            throw new UserException(RESTCodes.UserErrorCode.INVALID_OTP, Level.FINE);
        }
    }

    private boolean checkCode(String secret, int code) {
        Base32 codec = new Base32();
        byte[] decodedKey = codec.decode(secret);
        long t = System.currentTimeMillis() / 1000L / 30L;
        int window = 2;
        for (int i = -window; i <= window; ++i) {
            try {
                long hash = AuthController.generateTOTP(decodedKey, t + (long)i);
                if (hash != (long)code) continue;
                return true;
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                return false;
            }
        }
        return false;
    }

    private static int generateTOTP(byte[] key, long t) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] data = new byte[8];
        long value = t;
        int i = 8;
        while (i-- > 0) {
            data[i] = (byte)value;
            value >>>= 8;
        }
        SecretKeySpec signKey = new SecretKeySpec(key, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(signKey);
        byte[] hash = mac.doFinal(data);
        int offset = hash[19] & 0xF;
        long truncatedHash = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            truncatedHash <<= 8;
            truncatedHash |= (long)(hash[offset + i2] & 0xFF);
        }
        truncatedHash &= Integer.MAX_VALUE;
        return (int)(truncatedHash %= 1000000L);
    }

    public void checkRecoveryKey(String key) throws UserException {
        Users user = this.getUserFromKey(key);
        this.checkUserStatusAndKey(user, ValidationKeyType.PASSWORD, false);
        this.validate(user, key);
        user.setValidationKeyType(ValidationKeyType.PASSWORD_RESET);
        this.userFacade.update(user);
    }

    public Users validateRecoveryKey(String key, ValidationKeyType type) throws UserException {
        Users user = this.getUserFromKey(key);
        this.checkUserStatusAndKey(user, type, false);
        this.validate(user, key);
        return user;
    }

    public void resetValidationKey(Users user) {
        user.setValidationKey(null);
        user.setValidationKeyUpdated(null);
        user.setValidationKeyType(null);
        this.userFacade.update(user);
    }

    public void setValidationKey(Users user, String resetToken, ValidationKeyType type) {
        user.setValidationKey(resetToken);
        user.setValidationKeyUpdated((Date)new Timestamp(new Date().getTime()));
        user.setValidationKeyType(type);
        this.userFacade.update(user);
    }

    private void checkUserStatusAndKey(Users user, ValidationKeyType type, boolean newUser) throws UserException {
        this.checkUserStatus(user, newUser);
        if (user.getValidationKeyType() == null || !type.equals((Object)user.getValidationKeyType())) {
            throw new UserException(RESTCodes.UserErrorCode.INCORRECT_VALIDATION_KEY, Level.FINE);
        }
    }

    public void checkUserStatus(Users user, boolean newUser) throws UserException {
        if (user == null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_WAS_NOT_FOUND, Level.FINE);
        }
        if (newUser) {
            this.userStatusValidator.checkNewUserStatus(user.getStatus());
        } else {
            try {
                this.userStatusValidator.checkStatus(user.getStatus());
            }
            catch (UserException e) {
                throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_NOT_ACTIVE, Level.FINE, e.getErrorCode().getMessage());
            }
        }
    }

    public void sendNewRecoveryValidationKey(Users user, String url, boolean isPassword) throws MessagingException, UserException {
        CredentialsResetToken resetToken = this.generateResetToken(user, isPassword);
        this.passwordRecovery.sendRecoveryNotification(user, url, isPassword, resetToken);
    }

    public CredentialsResetToken generateResetToken(Users user, boolean isPassword) throws UserException {
        if (user == null) {
            throw new IllegalArgumentException("User not set.");
        }
        if (UserAccountType.REMOTE_ACCOUNT_TYPE.equals((Object)user.getMode())) {
            throw new UserException(RESTCodes.UserErrorCode.USER_WAS_NOT_FOUND, Level.FINE);
        }
        if (user.getValidationKey() != null && user.getValidationKeyType() != null && user.getValidationKeyUpdated() != null && user.getValidationKeyType().equals((Object)(isPassword ? ValidationKeyType.PASSWORD : ValidationKeyType.QR_RESET)) && this.diffMillis(user.getValidationKeyUpdated()) > TimeUnit.MINUTES.toMillis(5L)) {
            return CredentialsResetToken.of(user.getValidationKey(), this.diffMillis(user.getValidationKeyUpdated()));
        }
        String resetToken = this.securityUtils.generateSecureRandomString();
        this.setValidationKey(user, resetToken, isPassword ? ValidationKeyType.PASSWORD : ValidationKeyType.QR_RESET);
        return CredentialsResetToken.of(resetToken, RESET_LINK_IN_HOURS);
    }

    public long diffMillis(Date date) {
        if (date == null) {
            return -1L;
        }
        Date now = new Date();
        long validForMs = TimeUnit.HOURS.toMillis(24L);
        long diff = now.getTime() - date.getTime();
        long diffMs = validForMs - diff;
        return diffMs;
    }

    public void sendNewValidationKey(Users user, String linkUrl) throws MessagingException {
        if (user == null) {
            throw new IllegalArgumentException("User not set.");
        }
        String activationKey = this.securityUtils.generateSecureRandomString();
        this.sendEmailValidationKey(user, activationKey, linkUrl);
        this.setValidationKey(user, activationKey, ValidationKeyType.EMAIL);
    }

    public void sendEmailValidationKey(Users user, String activationKey, String linkUrl) throws MessagingException {
        long validForHour = this.diffMillis(user.getValidationKeyUpdated());
        String subject = "Your Hopsworks account needs verification";
        String msg = UserAccountsEmailMessages.buildMobileRequestMessageRest(linkUrl, user.getUsername() + this.securityUtils.urlEncode(activationKey), validForHour);
        this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, subject, msg);
    }

    public boolean isTwoFactorEnabled(Users user) {
        String[] groups;
        String twoFactorAuth = this.settings.getTwoFactorAuth();
        String twoFactorExclude = this.settings.getTwoFactorExclude();
        String twoFactorMode = twoFactorAuth != null ? twoFactorAuth : "";
        String excludes = twoFactorExclude != null ? twoFactorExclude : "";
        for (String group : groups = !excludes.isEmpty() ? excludes.split(";") : new String[]{}) {
            if (!this.isUserInRole(user, group)) continue;
            return false;
        }
        if (twoFactorMode.equals(Settings.TwoFactorMode.MANDATORY.getName())) {
            return true;
        }
        return twoFactorMode.equals(Settings.TwoFactorMode.OPTIONAL.getName()) && user.getTwoFactor();
    }

    public boolean isTwoFactorEnabled() {
        String twoFactorAuth = this.settings.getTwoFactorAuth();
        String twoFactorMode = twoFactorAuth != null ? twoFactorAuth : "";
        return twoFactorMode.equals(Settings.TwoFactorMode.MANDATORY.getName()) || twoFactorMode.equals(Settings.TwoFactorMode.OPTIONAL.getName());
    }

    public boolean isTwoFactorEnabled(boolean userTwoFactorEnabled) {
        String twoFactorAuth = this.settings.getTwoFactorAuth();
        String twoFactorMode = twoFactorAuth != null ? twoFactorAuth : "";
        return twoFactorMode.equals(Settings.TwoFactorMode.MANDATORY.getName()) || twoFactorMode.equals(Settings.TwoFactorMode.OPTIONAL.getName()) && userTwoFactorEnabled;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void changePassword(Users user, Secret secret) {
        String oldPassword = user.getPassword();
        user.setPassword(secret.getSha256HexDigest());
        user.setSalt(secret.getSalt());
        user.setPasswordChanged((Date)new Timestamp(new Date().getTime()));
        this.userFacade.update(user);
        this.resetProjectCertPassword(user, oldPassword);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void changeUserPasswordAsAdmin(Users user, Secret secret) {
        this.changePassword(user, secret);
    }

    public String getPasswordPlusSalt(String password, String salt) {
        return password + salt;
    }

    private void resetProjectCertPassword(Users p, String oldPass) {
        List<Project> projects = this.projectFacade.findAllMemberStudies(p);
        try {
            for (Project project : projects) {
                UserCerts userCert = this.userCertsFacade.findUserCert(project.getName(), p.getUsername());
                String masterEncryptionPassword = this.certificatesMgmService.getMasterEncryptionPassword();
                String certPassword = HopsUtils.decrypt(oldPass, userCert.getUserKeyPwd(), masterEncryptionPassword);
                String newSecret = HopsUtils.encrypt(p.getPassword(), certPassword, masterEncryptionPassword);
                userCert.setUserKeyPwd(newSecret);
                this.userCertsFacade.update(userCert);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            throw new EJBException(ex);
        }
    }

    public void registerFalseLogin(Users user) {
        if (user != null) {
            int allowedFalseLogins;
            int count = user.getFalseLogin() + 1;
            user.setFalseLogin(count);
            int n = allowedFalseLogins = this.isUserAgent(user) ? 20 : 5;
            if (count > allowedFalseLogins) {
                user.setStatus(UserAccountStatus.BLOCKED_ACCOUNT);
                try {
                    this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, "Your account is locked", UserAccountsEmailMessages.accountBlockedMessage());
                }
                catch (MessagingException ex) {
                    LOGGER.log(Level.SEVERE, "Failed to send email. ", ex);
                }
            }
            this.userFacade.update(user);
        }
    }

    private boolean isUserAgent(Users user) {
        return this.isUserInRole(user, "AGENT");
    }

    public void registerFalseKeyValidation(Users user) {
        if (user != null) {
            int count = user.getFalseLogin() + 1;
            user.setFalseLogin(count);
            if (count > 5) {
                user.setStatus(UserAccountStatus.SPAM_ACCOUNT);
            }
            this.userFacade.update(user);
        }
    }

    public void registerLogin(Users user) {
        this.resetFalseLogin(user);
        this.setUserOnlineStatus(user, 1);
        LOGGER.log(Level.FINEST, "Logged in user: {0}. ", user.getEmail());
    }

    public void registerLogin(Users user, HttpServletRequest req) {
        String remoteHost = HttpUtil.extractRemoteHostIp(req);
        String userAgent = HttpUtil.extractUserAgent(req);
        this.registerLogin(user);
        this.accountAuditFacade.registerLoginInfo(user, "LOGIN", "SUCCESS", remoteHost, userAgent);
    }

    public void registerLogout(Users user) {
        this.setUserOnlineStatus(user, 0);
        LOGGER.log(Level.FINEST, "Logged out user: {0}. ", user.getEmail());
    }

    public void registerAuthenticationFailure(Users user) {
        this.registerFalseLogin(user);
        LOGGER.log(Level.FINEST, "Authentication failure user: {0}. ", user.getEmail());
    }

    public void resetFalseLogin(Users user) {
        if (user != null) {
            user.setFalseLogin(0);
            this.userFacade.update(user);
        }
    }

    private void setUserOnlineStatus(Users user, int status) {
        if (user != null) {
            user.setIsonline(status);
            this.userFacade.update(user);
        }
    }

    private boolean isUserInRole(Users user, String groupName) {
        if (user == null || groupName == null) {
            return false;
        }
        BbcGroup group = this.bbcGroupFacade.findByGroupName(groupName);
        if (group == null) {
            return false;
        }
        return user.getBbcGroupCollection().contains(group);
    }

    public static class CredentialsResetToken {
        private final String token;
        private final long validity;

        public static CredentialsResetToken of(String token, long validity) {
            return new CredentialsResetToken(token, validity);
        }

        private CredentialsResetToken(String token, long validity) {
            this.token = token;
            this.validity = validity;
        }

        public String getToken() {
            return this.token;
        }

        public long getValidity() {
            return this.validity;
        }
    }
}

