/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.hops.hopsworks.common.featurestore.FeaturestoreEntityDTO;
import io.hops.hopsworks.common.featurestore.datavalidationv2.ExpectationSuiteDTO;
import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.ondemand.OnDemandFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.stream.StreamFeatureGroupDTO;
import io.hops.hopsworks.common.featurestore.statistics.StatisticsConfigDTO;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={CachedFeaturegroupDTO.class, StreamFeatureGroupDTO.class, OnDemandFeaturegroupDTO.class})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CachedFeaturegroupDTO.class, name="CachedFeaturegroupDTO"), @JsonSubTypes.Type(value=StreamFeatureGroupDTO.class, name="StreamFeatureGroupDTO"), @JsonSubTypes.Type(value=OnDemandFeaturegroupDTO.class, name="OnDemandFeaturegroupDTO")})
public class FeaturegroupDTO
extends FeaturestoreEntityDTO<FeaturegroupDTO> {
    @XmlElement
    private List<FeatureGroupFeatureDTO> features;
    @XmlElement
    private ExpectationSuiteDTO expectationSuite = null;
    @XmlElement
    private String onlineTopicName = null;
    @XmlElement
    private String eventTime = null;

    public FeaturegroupDTO() {
    }

    public FeaturegroupDTO(Integer featurestoreId, String featurestoreName, Integer id, String name, Integer version, String onlineTopicName) {
        super(featurestoreId, featurestoreName, id, name, version);
        this.onlineTopicName = onlineTopicName;
    }

    public FeaturegroupDTO(Featuregroup featuregroup) {
        super(featuregroup.getFeaturestore().getId(), featuregroup.getName(), featuregroup.getCreated(), featuregroup.getCreator(), featuregroup.getVersion(), featuregroup.getId(), new StatisticsConfigDTO(featuregroup.getStatisticsConfig()));
        this.eventTime = featuregroup.getEventTime();
        if (featuregroup.getExpectationSuite() != null) {
            this.expectationSuite = new ExpectationSuiteDTO(featuregroup.getExpectationSuite());
        }
    }

    public FeaturegroupDTO(Integer featurestoreId, String featurestoreName, Integer id, String name, Integer version, String onlineTopicName, ExpectationSuiteDTO expectationSuite) {
        super(featurestoreId, featurestoreName, id, name, version);
        this.onlineTopicName = onlineTopicName;
        this.expectationSuite = expectationSuite;
    }

    public FeaturegroupDTO(Integer featurestoreId, String featurestoreName, Integer id, String name, Integer version, ExpectationSuiteDTO expectationSuite) {
        super(featurestoreId, featurestoreName, id, name, version);
        this.expectationSuite = expectationSuite;
    }

    public FeaturegroupDTO(String eventTime) {
        this.eventTime = eventTime;
    }

    public List<FeatureGroupFeatureDTO> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<FeatureGroupFeatureDTO> features) {
        this.features = features;
    }

    public ExpectationSuiteDTO getExpectationSuite() {
        return this.expectationSuite;
    }

    public void setExpectationSuite(ExpectationSuiteDTO expectationSuite) {
        this.expectationSuite = expectationSuite;
    }

    public String getOnlineTopicName() {
        return this.onlineTopicName;
    }

    public void setOnlineTopicName(String onlineTopicName) {
        this.onlineTopicName = onlineTopicName;
    }

    public String getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(String eventTime) {
        this.eventTime = eventTime;
    }

    @Override
    public String toString() {
        return "FeaturegroupDTO{features=" + this.features + '}';
    }
}

