/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.cached;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.featurestore.activity.FeaturestoreActivityFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeatureGroupCommitFacade;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.FeaturegroupType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.FeatureGroupCommit;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.hive.HiveTbls;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeatureGroupCommitController {
    @EJB
    private FeatureGroupCommitFacade featureGroupCommitFacade;
    @EJB
    private FeaturestoreActivityFacade fsActivityFacade;
    @EJB
    private InodeController inodeController;
    private static final String HOODIE_METADATA_DIR = ".hoodie";
    private static final String HOODIE_COMMIT_METADATA_FILE = ".commit";
    private static final Logger LOGGER = Logger.getLogger(FeatureGroupCommitController.class.getName());

    public FeatureGroupCommit createHudiFeatureGroupCommit(Users user, Featuregroup featuregroup, String commitDateString, Long commitTime, Long rowsUpdated, Long rowsInserted, Long rowsDeleted, Integer validationId) throws FeaturestoreException {
        String commitPath = this.computeHudiCommitPath(featuregroup, commitDateString);
        Inode inode = this.inodeController.getInodeAtPath(commitPath);
        FeatureGroupCommit featureGroupCommit = new FeatureGroupCommit(featuregroup.getId(), commitTime);
        featureGroupCommit.setInode(inode);
        featureGroupCommit.setCommittedOn(new Timestamp(commitTime));
        featureGroupCommit.setNumRowsUpdated(rowsUpdated);
        featureGroupCommit.setNumRowsInserted(rowsInserted);
        featureGroupCommit.setNumRowsDeleted(rowsDeleted);
        if (validationId == null || validationId > 0) {
            // empty if block
        }
        featureGroupCommit = this.featureGroupCommitFacade.update(featureGroupCommit);
        this.fsActivityFacade.logCommitActivity(user, featuregroup, featureGroupCommit);
        return featureGroupCommit;
    }

    public Optional<FeatureGroupCommit> findCommitByDate(Featuregroup featuregroup, Long commitTimestamp) {
        if (commitTimestamp != null) {
            return this.featureGroupCommitFacade.findClosestDateCommit(featuregroup.getId(), commitTimestamp);
        }
        return this.featureGroupCommitFacade.findLatestDateCommit(featuregroup.getId());
    }

    public AbstractFacade.CollectionInfo getCommitDetails(Integer featureGroupId, Integer limit, Integer offset, Set<? extends AbstractFacade.SortBy> sort, Set<? extends AbstractFacade.FilterBy> filters) {
        if (filters == null || filters.isEmpty()) {
            return this.featureGroupCommitFacade.getCommitDetails(featureGroupId, limit, offset, sort);
        }
        return this.featureGroupCommitFacade.getCommitDetailsByDate(featureGroupId, limit, offset, sort, filters);
    }

    protected String computeHudiCommitPath(Featuregroup featuregroup, String commitDateString) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            dateFormat.parse(commitDateString).getTime();
        }
        catch (ParseException e) {
            LOGGER.log(Level.SEVERE, "Unable to recognize provided HUDI commitDateString ", e);
        }
        HiveTbls hiveTbls = featuregroup.getFeaturegroupType().equals((Object)FeaturegroupType.STREAM_FEATURE_GROUP) ? featuregroup.getStreamFeatureGroup().getHiveTbls() : featuregroup.getCachedFeaturegroup().getHiveTbls();
        String dbLocation = hiveTbls.getSdId().getLocation();
        Path commitMetadataPath = new Path(HOODIE_METADATA_DIR, commitDateString + HOODIE_COMMIT_METADATA_FILE);
        Path commitPath = new Path(dbLocation, commitMetadataPath);
        return commitPath.toString();
    }
}

