/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.alert;

import com.google.common.base.Strings;
import io.hops.hopsworks.alert.AlertManager;
import io.hops.hopsworks.alert.AlertManagerConfiguration;
import io.hops.hopsworks.alert.dao.AlertReceiverFacade;
import io.hops.hopsworks.alert.exception.AlertManagerAccessControlException;
import io.hops.hopsworks.alert.exception.AlertManagerUnreachableException;
import io.hops.hopsworks.alert.util.ConfigUtil;
import io.hops.hopsworks.alert.util.Constants;
import io.hops.hopsworks.alert.util.PostableAlertBuilder;
import io.hops.hopsworks.alerting.api.alert.dto.Alert;
import io.hops.hopsworks.alerting.api.alert.dto.PostableAlert;
import io.hops.hopsworks.alerting.config.dto.Route;
import io.hops.hopsworks.alerting.exceptions.AlertManagerClientCreateException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigCtrlCreateException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigReadException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigUpdateException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerDuplicateEntryException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerNoSuchElementException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerResponseException;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertReceiver;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertSeverity;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.FeatureGroupValidationStatus;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.alert.FeatureGroupAlert;
import io.hops.hopsworks.persistence.entity.jobs.configuration.history.JobFinalStatus;
import io.hops.hopsworks.persistence.entity.jobs.configuration.history.JobState;
import io.hops.hopsworks.persistence.entity.jobs.description.JobAlert;
import io.hops.hopsworks.persistence.entity.jobs.description.JobAlertStatus;
import io.hops.hopsworks.persistence.entity.jobs.history.Execution;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.alert.ProjectServiceAlert;
import io.hops.hopsworks.persistence.entity.project.alert.ProjectServiceAlertStatus;
import io.hops.hopsworks.persistence.entity.project.service.ProjectServiceEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class AlertController {
    private static final Logger LOGGER = Logger.getLogger(AlertController.class.getName());
    @EJB
    private AlertManager alertManager;
    @EJB
    private AlertManagerConfiguration alertManagerConfiguration;
    @EJB
    private AlertReceiverFacade alertReceiverFacade;

    public void sendAlert(JobState newState, Execution execution) {
        List<PostableAlert> postableAlerts = this.getAlerts(newState, execution);
        this.sendJobAlert(postableAlerts, execution.getJob().getProject(), execution.getJob().getName(), execution.getId());
    }

    public void sendAlert(JobFinalStatus newState, Execution execution) {
        List<PostableAlert> postableAlerts = this.getAlerts(newState, execution);
        this.sendJobAlert(postableAlerts, execution.getJob().getProject(), execution.getJob().getName(), execution.getId());
    }

    public List<Alert> testAlert(Project project, FeatureGroupAlert alert) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerResponseException, AlertManagerClientCreateException {
        return this.sendFgTestAlert(project, alert.getAlertType(), alert.getSeverity(), FeatureGroupValidationStatus.fromString((String)alert.getStatus().toString()), alert.getFeatureGroup().getName());
    }

    public List<Alert> testAlert(Project project, JobAlert alert) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerResponseException, AlertManagerClientCreateException {
        return this.sendJobTestAlert(project, alert.getAlertType(), alert.getSeverity(), alert.getStatus().getName(), alert.getJobId().getName());
    }

    public List<Alert> testAlert(Project project, ProjectServiceAlert alert) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerResponseException, AlertManagerClientCreateException {
        List<Alert> alerts = null;
        if (ProjectServiceEnum.FEATURESTORE.equals((Object)alert.getService())) {
            alerts = this.sendFgTestAlert(project, alert.getAlertType(), alert.getSeverity(), FeatureGroupValidationStatus.fromString((String)alert.getStatus().toString()), null);
        } else if (ProjectServiceEnum.JOBS.equals((Object)alert.getService())) {
            alerts = this.sendJobTestAlert(project, alert.getAlertType(), alert.getSeverity(), alert.getStatus().getName(), null);
        }
        return alerts;
    }

    private void sendAlert(List<PostableAlert> postableAlerts, Project project) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerResponseException, AlertManagerClientCreateException {
        if (!postableAlerts.isEmpty()) {
            this.alertManager.postAlerts(postableAlerts, project);
        }
    }

    public void sendFgAlert(List<PostableAlert> postableAlerts, Project project, String name) {
        try {
            this.sendAlert(postableAlerts, project);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to send alert. Featuregroup={0}. Exception: {1}", new Object[]{name, e.getMessage()});
        }
    }

    private void sendJobAlert(List<PostableAlert> postableAlerts, Project project, String name, Integer id) {
        try {
            this.sendAlert(postableAlerts, project);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to send alert. Job={0} executionId={1}. Exception: {2}", new Object[]{name, id, e.getMessage()});
        }
    }

    private List<Alert> sendFgTestAlert(Project project, AlertType alertType, AlertSeverity severity, FeatureGroupValidationStatus status, String fgName) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerResponseException, AlertManagerClientCreateException {
        String testAlertFgName = Strings.isNullOrEmpty((String)fgName) ? "AlertTestFeatureGroup" : fgName;
        ArrayList<PostableAlert> postableAlerts = new ArrayList<PostableAlert>();
        PostableAlert postableAlert = this.getPostableFgAlert(project.getName(), alertType, severity, status.getName(), "Alert test summary.", "Alert test description.", Constants.TEST_ALERT_FG_ID, "AlertTestFeatureStore", testAlertFgName, Constants.TEST_ALERT_FG_VERSION);
        postableAlerts.add(postableAlert);
        this.sendAlert(postableAlerts, project);
        String fgFilter = "featureGroup=\"%%fg%%\"".replace("%%fg%%", testAlertFgName) + "featureGroupId=\"%%fgId%%\"".replace("%%fgId%%", Constants.TEST_ALERT_FG_ID.toString());
        return this.getAlerts(project, fgFilter);
    }

    private List<Alert> sendJobTestAlert(Project project, AlertType alertType, AlertSeverity severity, String status, String jobName) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerResponseException, AlertManagerClientCreateException {
        ArrayList<PostableAlert> postableAlerts = new ArrayList<PostableAlert>();
        String testAlertJobName = Strings.isNullOrEmpty((String)jobName) ? "AlertTestJob" : jobName;
        PostableAlert postableAlert = this.getPostableAlert(project, alertType, severity, status, testAlertJobName, Constants.TEST_ALERT_EXECUTION_ID);
        postableAlerts.add(postableAlert);
        this.sendAlert(postableAlerts, project);
        String jobFilter = "job=\"%%job%%\"".replace("%%job%%", testAlertJobName) + "executionId=\"%%executionId%%\"".replace("%%executionId%%", Constants.TEST_ALERT_EXECUTION_ID.toString());
        return this.getAlerts(project, jobFilter);
    }

    private List<Alert> getAlerts(Project project, String filter) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerResponseException, AlertManagerClientCreateException {
        HashSet<String> filters = new HashSet<String>();
        String projectFilter = "project=\"%%project%%\"".replace("%%project%%", project.getName());
        filters.add(projectFilter);
        filters.add(filter);
        List alerts = this.alertManager.getAlerts(Boolean.valueOf(true), null, null, null, filters, null, project);
        return alerts;
    }

    public PostableAlert getPostableFgAlert(String projectName, AlertType alertType, AlertSeverity severity, String status, String summary, String description, Integer id, String featureStoreName, String featureGroupName, int version) {
        return new PostableAlertBuilder.Builder(projectName, alertType, severity, status).withFeatureGroupId(id).withFeatureStoreName(featureStoreName).withFeatureGroupName(featureGroupName).withFeatureGroupVersion(Integer.valueOf(version)).withSummary(summary).withDescription(description).build();
    }

    private PostableAlert getPostableAlert(Project project, AlertType alertType, AlertSeverity severity, String status, String jobName, Integer id) {
        return new PostableAlertBuilder.Builder(project.getName(), alertType, severity, status).withJobName(jobName).withExecutionId(id).withSummary("Job " + status).withDescription("Job=" + jobName + " with executionId=" + id + " " + status.toLowerCase()).build();
    }

    private List<PostableAlert> getAlerts(JobState jobState, Execution execution) {
        List<PostableAlert> postableAlerts = new ArrayList<PostableAlert>();
        if (jobState.isFinalState()) {
            postableAlerts = this.getAlerts(JobAlertStatus.getJobAlertStatus((JobState)jobState), ProjectServiceAlertStatus.getJobAlertStatus((JobState)jobState), execution);
        }
        return postableAlerts;
    }

    private List<PostableAlert> getAlerts(JobFinalStatus jobState, Execution execution) {
        List<PostableAlert> postableAlerts = new ArrayList<PostableAlert>();
        if (!JobFinalStatus.UNDEFINED.equals((Object)jobState)) {
            postableAlerts = this.getAlerts(JobAlertStatus.getJobAlertStatus((JobFinalStatus)jobState), ProjectServiceAlertStatus.getJobAlertStatus((JobFinalStatus)jobState), execution);
        }
        return postableAlerts;
    }

    private List<PostableAlert> getAlerts(JobAlertStatus jobAlertStatus, ProjectServiceAlertStatus projectServiceAlertStatus, Execution execution) {
        ArrayList<PostableAlert> postableAlerts;
        block3: {
            block2: {
                postableAlerts = new ArrayList<PostableAlert>();
                if (execution.getJob().getJobAlertCollection() == null || execution.getJob().getJobAlertCollection().isEmpty()) break block2;
                for (JobAlert alert : execution.getJob().getJobAlertCollection()) {
                    if (!alert.getStatus().equals((Object)jobAlertStatus)) continue;
                    PostableAlert postableAlert = this.getPostableAlert(execution.getJob().getProject(), alert.getAlertType(), alert.getSeverity(), alert.getStatus().getName(), execution.getJob().getName(), execution.getId());
                    postableAlerts.add(postableAlert);
                }
                break block3;
            }
            if (execution.getJob().getProject().getProjectServiceAlerts() == null || execution.getJob().getProject().getProjectServiceAlerts().isEmpty()) break block3;
            for (ProjectServiceAlert alert : execution.getJob().getProject().getProjectServiceAlerts()) {
                if (!ProjectServiceEnum.JOBS.equals((Object)alert.getService()) || !alert.getStatus().equals((Object)projectServiceAlertStatus)) continue;
                PostableAlert postableAlert = this.getPostableAlert(execution.getJob().getProject(), alert.getAlertType(), alert.getSeverity(), alert.getStatus().getName(), execution.getJob().getName(), execution.getId());
                postableAlerts.add(postableAlert);
            }
        }
        return postableAlerts;
    }

    public void cleanProjectAlerts(Project project) throws AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, AlertManagerUnreachableException, AlertManagerResponseException, AlertManagerClientCreateException, AlertManagerConfigUpdateException {
        this.alertManagerConfiguration.cleanProject(project);
    }

    private void addRouteIfNotExist(AlertType type, Route route, Project project) throws AlertManagerUnreachableException, AlertManagerNoSuchElementException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, AlertManagerClientCreateException, AlertManagerAccessControlException {
        try {
            if (type.isGlobal()) {
                this.alertManagerConfiguration.addRoute(route);
            } else {
                this.alertManagerConfiguration.addRoute(route, project);
            }
        }
        catch (AlertManagerDuplicateEntryException alertManagerDuplicateEntryException) {
            // empty catch block
        }
    }

    public void createRoute(ProjectServiceAlert alert) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerNoSuchElementException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, AlertManagerClientCreateException {
        Project project = alert.getProject();
        Route route = ConfigUtil.getRoute((ProjectServiceAlert)alert);
        this.addRouteIfNotExist(alert.getAlertType(), route, project);
    }

    public void createRoute(FeatureGroupAlert alert) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerNoSuchElementException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, AlertManagerClientCreateException {
        Project project = alert.getFeatureGroup().getFeaturestore().getProject();
        Route route = ConfigUtil.getRoute((FeatureGroupAlert)alert);
        this.addRouteIfNotExist(alert.getAlertType(), route, project);
    }

    public void createRoute(JobAlert alert) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerNoSuchElementException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, AlertManagerClientCreateException {
        Project project = alert.getJobId().getProject();
        Route route = ConfigUtil.getRoute((JobAlert)alert);
        this.addRouteIfNotExist(alert.getAlertType(), route, project);
    }

    public void createRoute(AlertType alertType) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerNoSuchElementException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, AlertManagerClientCreateException {
        Route route = ConfigUtil.getRoute((AlertType)alertType);
        try {
            this.alertManagerConfiguration.addRoute(route);
        }
        catch (AlertManagerDuplicateEntryException alertManagerDuplicateEntryException) {
            // empty catch block
        }
    }

    public void deleteRoute(ProjectServiceAlert alert) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, AlertManagerClientCreateException {
        Project project = alert.getProject();
        Route route = ConfigUtil.getRoute((ProjectServiceAlert)alert);
        if (!this.isUsedByOtherAlerts(route, alert.getId())) {
            this.alertManagerConfiguration.removeRoute(route, project);
        }
    }

    public void deleteRoute(FeatureGroupAlert alert) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, AlertManagerClientCreateException {
        Project project = alert.getFeatureGroup().getFeaturestore().getProject();
        Route route = ConfigUtil.getRoute((FeatureGroupAlert)alert);
        if (!this.isUsedByOtherAlerts(route, alert.getId())) {
            this.alertManagerConfiguration.removeRoute(route, project);
        }
    }

    public void deleteRoute(JobAlert alert) throws AlertManagerUnreachableException, AlertManagerAccessControlException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, AlertManagerClientCreateException {
        Project project = alert.getJobId().getProject();
        Route route = ConfigUtil.getRoute((JobAlert)alert);
        if (!this.isUsedByOtherAlerts(route, alert.getId())) {
            this.alertManagerConfiguration.removeRoute(route, project);
        }
    }

    private boolean isUsedByOtherAlerts(Route route, int id) {
        Optional alertReceiver = this.alertReceiverFacade.findByName(route.getReceiver());
        if (!alertReceiver.isPresent()) {
            return false;
        }
        if (route.getMatch().get("job") != null) {
            Collection jobAlerts = ((AlertReceiver)alertReceiver.get()).getJobAlertCollection();
            for (JobAlert alert : jobAlerts) {
                Route jobAlertRoute = ConfigUtil.getRoute((JobAlert)alert);
                if (alert.getId() == id || !jobAlertRoute.equals((Object)route)) continue;
                return true;
            }
        } else if (route.getMatch().get("featureGroup") != null) {
            Collection featureGroupAlerts = ((AlertReceiver)alertReceiver.get()).getFeatureGroupAlertCollection();
            for (FeatureGroupAlert alert : featureGroupAlerts) {
                Route fgAlertRoute = ConfigUtil.getRoute((FeatureGroupAlert)alert);
                if (alert.getId() == id || !fgAlertRoute.equals((Object)route)) continue;
                return true;
            }
        } else {
            Collection projectServiceAlerts = ((AlertReceiver)alertReceiver.get()).getProjectServiceAlertCollection();
            for (ProjectServiceAlert alert : projectServiceAlerts) {
                Route projectAlertRoute = ConfigUtil.getRoute((ProjectServiceAlert)alert);
                if (alert.getId() == id || !projectAlertRoute.equals((Object)route)) continue;
                return true;
            }
        }
        return false;
    }

    public AlertType getAlertType(AlertReceiver receiver) {
        AlertType alertType = AlertType.fromReceiverName((String)receiver.getName());
        if (alertType == null) {
            return AlertType.PROJECT_ALERT;
        }
        return alertType;
    }
}

