/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.tensorflow;

import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.tensorflow.TensorBoard;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.validation.ConstraintViolationException;

@Stateless
public class TensorBoardFacade {
    private static final Logger LOGGER = Logger.getLogger(TensorBoardFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public void persist(TensorBoard tensorBoard) {
        try {
            this.em.persist((Object)tensorBoard);
            this.em.flush();
        }
        catch (ConstraintViolationException ex) {
            LOGGER.log(Level.SEVERE, "Could not update TensorBoard", ex);
            throw ex;
        }
    }

    public void update(TensorBoard tensorBoard) {
        try {
            this.em.merge((Object)tensorBoard);
            this.em.flush();
        }
        catch (ConstraintViolationException ex) {
            LOGGER.log(Level.SEVERE, "Could not update TensorBoard", ex);
            throw ex;
        }
    }

    public void remove(TensorBoard tensorBoard) {
        try {
            TensorBoard managedTfServing = (TensorBoard)this.em.find(TensorBoard.class, (Object)tensorBoard.getTensorBoardPK());
            this.em.remove(this.em.merge((Object)managedTfServing));
            this.em.flush();
        }
        catch (IllegalStateException | SecurityException ex) {
            LOGGER.log(Level.SEVERE, "Could not update TensorBoard", ex);
            throw ex;
        }
    }

    public List<TensorBoard> findAll() {
        TypedQuery q = this.em.createNamedQuery("TensorBoard.findAll", TensorBoard.class);
        return q.getResultList();
    }

    public TensorBoard findForProjectAndUser(Project project, Users user) {
        try {
            TypedQuery q = this.em.createNamedQuery("TensorBoard.findByProjectAndUser", TensorBoard.class);
            q.setParameter("projectId", (Object)project.getId());
            q.setParameter("userId", (Object)user.getUid());
            TensorBoard tb = (TensorBoard)q.getSingleResult();
            return tb;
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    public List<TensorBoard> findByUserEmail(String email) {
        TypedQuery q = this.em.createNamedQuery("TensorBoard.findByUserEmail", TensorBoard.class);
        q.setParameter("email", (Object)email);
        return q.getResultList();
    }

    public List<TensorBoard> findForProject(Project project) {
        TypedQuery q = this.em.createNamedQuery("TensorBoard.findByProjectId", TensorBoard.class);
        q.setParameter("projectId", (Object)project.getId());
        return q.getResultList();
    }

    public TensorBoard findByMlId(String mlId) {
        try {
            TypedQuery q = this.em.createNamedQuery("TensorBoard.findByMlId", TensorBoard.class);
            q.setParameter("mlId", (Object)mlId);
            TensorBoard tb = (TensorBoard)q.getSingleResult();
            return tb;
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }
}

