/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.datavalidationv2;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.ValidationReport;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.validation.ConstraintViolationException;

@Stateless
public class ValidationReportFacade
extends AbstractFacade<ValidationReport> {
    private static final Logger LOGGER = Logger.getLogger(ValidationReportFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public ValidationReportFacade() {
        super(ValidationReport.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void persist(ValidationReport validationReport) {
        try {
            this.em.persist((Object)validationReport);
            this.em.flush();
        }
        catch (ConstraintViolationException cve) {
            LOGGER.log(Level.WARNING, "Could not persist the new ValidationReport", cve);
        }
    }

    public Optional<ValidationReport> findById(Integer id) {
        try {
            return Optional.of(this.em.createNamedQuery("ValidationReport.findById", ValidationReport.class).setParameter("id", (Object)id).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public AbstractFacade.CollectionInfo<ValidationReport> findByFeaturegroup(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, Featuregroup featuregroup) {
        String queryStr = this.buildQuery("SELECT vr from ValidationReport vr ", filters, sorts, "vr.featuregroup = :featuregroup");
        String queryCountStr = this.buildQuery("SELECT COUNT(vr.id) from ValidationReport vr ", filters, sorts, "vr.featuregroup = :featuregroup");
        TypedQuery query = this.em.createQuery(queryStr, ValidationReport.class).setParameter("featuregroup", (Object)featuregroup);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, ValidationReport.class).setParameter("featuregroup", (Object)featuregroup);
        this.setFilter(filters, (Query)query);
        this.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo<ValidationReport>((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public Optional<ValidationReport> findFeaturegroupLatestValidationReport(Featuregroup featuregroup) {
        List validationReports = this.em.createNamedQuery("ValidationReport.findByFeaturegroupOrderedByDescDate", ValidationReport.class).setParameter("featuregroup", (Object)featuregroup).getResultList();
        Optional<Object> latestReport = validationReports.size() == 0 ? Optional.empty() : Optional.of(validationReports.get(0));
        return latestReport;
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            q.setParameter(filterBy.getField(), (Object)new Timestamp(Long.parseLong(filterBy.getParam())));
        }
    }

    public static enum Filters {
        VALIDATION_TIME_GT("VALIDATION_TIME_GT", "vr.validationTime > :validationTime ", "validationTime", ""),
        VALIDATION_TIME_LT("VALIDATION_TIME_LT", "vr.validationTime < :validationTime ", "validationTime", ""),
        VALIDATION_TIME_EQ("VALIDATION_TIME_EQ", "vr.validationTime = :validationTime ", "validationTime", "");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        VALIDATION_TIME("VALIDATION_TIME", "vr.validationTime ", "DESC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }
}

