/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup;

import io.hops.hopsworks.common.featurestore.FeaturestoreConstants;
import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.online.OnlineFeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.stream.StreamFeatureGroupDTO;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreInputValidation;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang.StringUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeatureGroupInputValidation {
    @EJB
    private FeaturestoreInputValidation featureStoreInputValidation;
    @EJB
    private OnlineFeaturegroupController onlineFeaturegroupController;

    public void verifyUserInput(FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        this.featureStoreInputValidation.verifyUserInput(featuregroupDTO);
        this.verifyFeatureGroupFeatureList(featuregroupDTO.getFeatures());
    }

    public void verifyFeatureGroupFeatureList(List<FeatureGroupFeatureDTO> featureGroupFeatureDTOS) throws FeaturestoreException {
        if (featureGroupFeatureDTOS != null && !featureGroupFeatureDTOS.isEmpty()) {
            for (FeatureGroupFeatureDTO featureGroupFeatureDTO : featureGroupFeatureDTOS) {
                this.featureStoreInputValidation.nameValidation(featureGroupFeatureDTO.getName());
                this.featureStoreInputValidation.descriptionValidation(featureGroupFeatureDTO.getName(), featureGroupFeatureDTO.getDescription());
            }
        }
    }

    public void verifyEventTimeFeature(String name, List<FeatureGroupFeatureDTO> features) throws FeaturestoreException {
        if (name == null) {
            return;
        }
        Optional<FeatureGroupFeatureDTO> eventTimeFeature = features.stream().filter(feature -> feature.getName().equalsIgnoreCase(name)).findAny();
        if (eventTimeFeature.isPresent()) {
            if (!FeaturestoreConstants.EVENT_TIME_FEATURE_TYPES.contains(eventTimeFeature.get().getType().toUpperCase())) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_EVENT_TIME_FEATURE_TYPE, Level.FINE, ", the provided event time feature `" + name + "` is of type `" + eventTimeFeature.get().getType() + "` but can only be one of the following types: " + FeaturestoreConstants.EVENT_TIME_FEATURE_TYPES + ".");
            }
        } else {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.EVENT_TIME_FEATURE_NOT_FOUND, Level.FINE, ", the provided event time feature `" + name + "` was not found among the available features: " + features.stream().map(FeatureGroupFeatureDTO::getName).collect(Collectors.joining(", ")) + ".");
        }
    }

    public void verifySchemaProvided(FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        if (featuregroupDTO instanceof CachedFeaturegroupDTO && ((CachedFeaturegroupDTO)featuregroupDTO).getOnlineEnabled().booleanValue() && featuregroupDTO.getFeatures().isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_ONLINE_FEATUREGROUP, Level.SEVERE, "Cannot create an online feature group without a feature schema.");
        }
    }

    public void verifyOnlineOfflineTypeMatch(FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        if (featuregroupDTO instanceof CachedFeaturegroupDTO && ((CachedFeaturegroupDTO)featuregroupDTO).getOnlineEnabled().booleanValue() || featuregroupDTO instanceof StreamFeatureGroupDTO && ((StreamFeatureGroupDTO)featuregroupDTO).getOnlineEnabled().booleanValue()) {
            for (FeatureGroupFeatureDTO feature : featuregroupDTO.getFeatures()) {
                String onlineType;
                String offlineType = feature.getType().toLowerCase().replace(" ", "");
                if (offlineType.equals(onlineType = this.onlineFeaturegroupController.getOnlineType(feature).toLowerCase().replace(" ", "")) || offlineType.equals("int") && (onlineType.equals("tinyint") || onlineType.equals("smallint")) || offlineType.equals("boolean") && onlineType.equals("tinyint") || offlineType.equals("string") && (onlineType.startsWith("varchar") || onlineType.equals("text")) || (offlineType.startsWith("array") || offlineType.startsWith("struct") || offlineType.startsWith("binary")) && (onlineType.startsWith("varbinary") || onlineType.equals("blob"))) continue;
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_ONLINE_FEATUREGROUP, Level.SEVERE, "Cannot create an online feature group because offline and online types are not compatible. Feature: " + feature.getName() + " (offline type '" + offlineType + "', online type '" + onlineType + "')");
            }
        }
    }

    public void verifyOnlineSchemaValid(FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        if (featuregroupDTO instanceof CachedFeaturegroupDTO && ((CachedFeaturegroupDTO)featuregroupDTO).getOnlineEnabled().booleanValue() || featuregroupDTO instanceof StreamFeatureGroupDTO && ((StreamFeatureGroupDTO)featuregroupDTO).getOnlineEnabled().booleanValue()) {
            if (featuregroupDTO.getFeatures().size() > FeaturestoreConstants.MAX_MYSQL_COLUMNS) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_ONLINE_FEATUREGROUP, Level.SEVERE, "Cannot create an online feature group because it contains > " + FeaturestoreConstants.MAX_MYSQL_COLUMNS + " rows (provided: " + featuregroupDTO.getFeatures().size() + " rows).");
            }
            Integer totalBytes = 0;
            for (FeatureGroupFeatureDTO feature : featuregroupDTO.getFeatures()) {
                String onlineType = this.onlineFeaturegroupController.getOnlineType(feature).toLowerCase().replace(" ", "");
                totalBytes = totalBytes + this.estimateOnlineSize(onlineType);
            }
            if (totalBytes > FeaturestoreConstants.MAX_MYSQL_COLUMN_SIZE) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_ONLINE_FEATUREGROUP, Level.SEVERE, "Cannot create an online feature group because row size > " + FeaturestoreConstants.MAX_MYSQL_COLUMN_SIZE + " bytes (estimated size: " + totalBytes + " bytes).");
            }
        }
    }

    public void verifyPrimaryKeySupported(FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        if (featuregroupDTO instanceof CachedFeaturegroupDTO && ((CachedFeaturegroupDTO)featuregroupDTO).getOnlineEnabled().booleanValue() || featuregroupDTO instanceof StreamFeatureGroupDTO && ((StreamFeatureGroupDTO)featuregroupDTO).getOnlineEnabled().booleanValue()) {
            Integer totalBytes = 0;
            for (FeatureGroupFeatureDTO feature : featuregroupDTO.getFeatures()) {
                if (!feature.getPrimary().booleanValue()) continue;
                String pkType = this.onlineFeaturegroupController.getOnlineType(feature).toLowerCase().replace(" ", "");
                Boolean found = false;
                for (String supportedName : FeaturestoreConstants.SUPPORTED_MYSQL_PRIMARY_KEYS) {
                    if (!pkType.startsWith(supportedName.toLowerCase())) continue;
                    found = true;
                    break;
                }
                totalBytes = totalBytes + this.estimateOnlineSize(pkType);
                if (found.booleanValue()) continue;
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_ONLINE_FEATUREGROUP, Level.SEVERE, "Cannot create an online feature group because primary key type is not supported. Feature: " + feature.getName() + " (offline type '" + feature.getType() + "', online type '" + this.onlineFeaturegroupController.getOnlineType(feature) + "')");
            }
            if (totalBytes > FeaturestoreConstants.MAX_MYSQL_PRIMARY_KEY_SIZE) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_ONLINE_FEATUREGROUP, Level.SEVERE, "Cannot create an online feature group because primary key is > " + FeaturestoreConstants.MAX_MYSQL_PRIMARY_KEY_SIZE + " bytes (estimated size: " + totalBytes + " bytes).");
            }
        }
    }

    private Integer estimateOnlineSize(String onlineFeatureType) {
        if (onlineFeatureType.equals("tinyint")) {
            return 1;
        }
        if (onlineFeatureType.equals("smallint")) {
            return 2;
        }
        if (onlineFeatureType.equals("int")) {
            return 4;
        }
        if (onlineFeatureType.equals("float")) {
            return 4;
        }
        if (onlineFeatureType.equals("bigint")) {
            return 8;
        }
        if (onlineFeatureType.equals("double")) {
            return 8;
        }
        if (onlineFeatureType.startsWith("decimal")) {
            return 16;
        }
        if (onlineFeatureType.equals("blob") || onlineFeatureType.equals("text")) {
            return 256;
        }
        if (onlineFeatureType.startsWith("varchar") && onlineFeatureType.contains("latin1")) {
            return Integer.parseInt(StringUtils.substringBetween((String)onlineFeatureType, (String)"(", (String)")"));
        }
        if (onlineFeatureType.startsWith("varchar")) {
            return Integer.parseInt(StringUtils.substringBetween((String)onlineFeatureType, (String)"(", (String)")")) * 4;
        }
        if (onlineFeatureType.startsWith("varbinary")) {
            return Math.round((float)Integer.parseInt(onlineFeatureType.replace("varbinary(", "").replace(")", "")) * 1.4f);
        }
        return 8;
    }
}

