/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.updates.analyzer;

import io.hops.hopsworks.common.python.library.LibraryVersionDTO;
import io.hops.hopsworks.common.python.updates.analyzer.LatestVersionAnalyzer;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class HopsLatestVersionAnalyzer
extends LatestVersionAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(HopsLatestVersionAnalyzer.class.getName());

    @Override
    public String getLibrary() {
        return "hops";
    }

    @Override
    public void setLatestVersion(String currentHopsworksVersion, HashMap<String, List<LibraryVersionDTO>> versions) {
        if (versions != null && !versions.isEmpty() && versions.containsKey(this.getLibrary())) {
            List<LibraryVersionDTO> searchVersionHits = versions.get(this.getLibrary());
            List currentVersionSearchHits = searchVersionHits.stream().filter(version -> version.getVersion().startsWith(currentHopsworksVersion)).collect(Collectors.toList());
            if (!(currentVersionSearchHits = currentVersionSearchHits.stream().sorted(new LatestVersionAnalyzer.SortByVersionComparator()).collect(Collectors.toList())).isEmpty()) {
                this.latestVersion = ((LibraryVersionDTO)currentVersionSearchHits.get(currentVersionSearchHits.size() - 1)).getVersion();
            } else {
                LOGGER.log(Level.SEVERE, "Could not find library version for " + this.getLibrary() + " for hopsworks version " + currentHopsworksVersion);
            }
        } else {
            LOGGER.log(Level.SEVERE, "Could not find library " + this.getLibrary() + " in PyPi search");
        }
    }
}

