/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.datavalidationv2;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.featurestore.datavalidationv2.ExpectationDTO;
import io.hops.hopsworks.common.featurestore.datavalidationv2.ExpectationSuiteDTO;
import io.hops.hopsworks.common.featurestore.datavalidationv2.ExpectationSuiteFacade;
import io.hops.hopsworks.common.featurestore.datavalidationv2.GreatExpectationFacade;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.Expectation;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.ExpectationSuite;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.GreatExpectation;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.json.JSONException;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ExpectationSuiteController {
    private static final Logger LOGGER = Logger.getLogger(ExpectationSuiteController.class.getName());
    @EJB
    ExpectationSuiteFacade expectationSuiteFacade;
    @EJB
    GreatExpectationFacade greatExpectationFacade;

    public AbstractFacade.CollectionInfo<GreatExpectation> getAllGreatExpectations() {
        return this.greatExpectationFacade.findAllGreatExpectation();
    }

    public ExpectationSuite getExpectationSuite(Featuregroup featureGroup) {
        Optional<ExpectationSuite> e = this.expectationSuiteFacade.findByFeaturegroup(featureGroup);
        return e.orElse(null);
    }

    public ExpectationSuite createExpectationSuite(Featuregroup featureGroup, ExpectationSuiteDTO expectationSuiteDTO) throws FeaturestoreException {
        Optional<ExpectationSuite> e = this.expectationSuiteFacade.findByFeaturegroup(featureGroup);
        this.verifyExpectationSuite(expectationSuiteDTO);
        if (e.isPresent()) {
            this.deleteExpectationSuite(featureGroup);
        }
        ExpectationSuite expectationSuite = this.convertExpectationSuiteDTOToPersistent(featureGroup, expectationSuiteDTO);
        this.expectationSuiteFacade.persist(expectationSuite);
        return expectationSuite;
    }

    public void deleteExpectationSuite(Featuregroup featureGroup) {
        this.expectationSuiteFacade.remove(this.getExpectationSuite(featureGroup));
    }

    public ExpectationSuite convertExpectationSuiteDTOToPersistent(Featuregroup featuregroup, ExpectationSuiteDTO expectationSuiteDTO) {
        ExpectationSuite expectationSuite = new ExpectationSuite();
        expectationSuite.setFeaturegroup(featuregroup);
        expectationSuite.setMeta(expectationSuiteDTO.getMeta());
        expectationSuite.setName(expectationSuiteDTO.getExpectationSuiteName());
        expectationSuite.setValidationIngestionPolicy(expectationSuiteDTO.getValidationIngestionPolicy());
        expectationSuite.setRunValidation(expectationSuiteDTO.getRunValidation());
        expectationSuite.setDataAssetType(expectationSuiteDTO.getDataAssetType());
        expectationSuite.setGeCloudId(expectationSuiteDTO.getGeCloudId());
        ArrayList<Expectation> persistentExpectations = new ArrayList<Expectation>();
        for (ExpectationDTO dto : expectationSuiteDTO.getExpectations()) {
            persistentExpectations.add(this.convertExpectationDTOToPersistent(expectationSuite, dto));
        }
        expectationSuite.setExpectations(persistentExpectations);
        return expectationSuite;
    }

    public Expectation convertExpectationDTOToPersistent(ExpectationSuite expectationSuite, ExpectationDTO dto) {
        Expectation persistentExpectation = new Expectation();
        persistentExpectation.setExpectationSuite(expectationSuite);
        persistentExpectation.setKwargs(dto.getKwargs());
        persistentExpectation.setMeta(dto.getMeta());
        persistentExpectation.setExpectationType(dto.getExpectationType());
        return persistentExpectation;
    }

    public void verifyExpectationSuite(ExpectationSuiteDTO dto) throws FeaturestoreException {
        if (dto == null) {
            return;
        }
        this.verifyExpectationSuiteFields(dto);
        for (ExpectationDTO expectationDTO : dto.getExpectations()) {
            this.verifyExpectationFields(expectationDTO);
        }
    }

    private void verifyExpectationSuiteFields(ExpectationSuiteDTO dto) throws FeaturestoreException {
        this.verifyExpectationSuiteGeCloudId(dto);
        this.verifyExpectationSuiteDataAssetType(dto);
        this.verifyExpectationSuiteMeta(dto);
        this.verifyExpectationSuiteName(dto);
    }

    private void verifyExpectationSuiteName(ExpectationSuiteDTO dto) throws FeaturestoreException {
        String expectationSuiteName = dto.getExpectationSuiteName();
        if (expectationSuiteName == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_NULLABLE, Level.SEVERE, "Expectation Suite Name cannot be null. Pass an empty string.");
        }
        if (expectationSuiteName.length() > 63) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Expectation Suite Name %s exceeds the max allowed character length %d.", expectationSuiteName, 63));
        }
    }

    private void verifyExpectationSuiteMeta(ExpectationSuiteDTO dto) throws FeaturestoreException {
        String meta = dto.getMeta();
        if (meta == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_NULLABLE, Level.SEVERE, "Expectation Suite Meta cannot be null. Pass a stringified Json.");
        }
        if (meta.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Expectation Suite Meta field %s exceeds the max allowed character length %d.", meta, 1000));
        }
        try {
            new JSONObject(meta);
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_VALID_JSON, Level.SEVERE, String.format("Expectation Suite Meta field %s is not a valid json.", meta), e.getMessage());
        }
    }

    private void verifyExpectationSuiteGeCloudId(ExpectationSuiteDTO dto) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)dto.getGeCloudId()) && dto.getGeCloudId().length() > 200) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Expectation Suite Ge Cloud Id %s exceeds the max allowed character length %d.", dto.getGeCloudId(), 200));
        }
    }

    private void verifyExpectationSuiteDataAssetType(ExpectationSuiteDTO dto) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)dto.getDataAssetType()) && dto.getDataAssetType().length() > 50) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Expectation Suite Data Asset Type %s exceeds the max allowed character length %d.", dto.getDataAssetType(), 50));
        }
    }

    void verifyExpectationFields(ExpectationDTO dto) throws FeaturestoreException {
        this.verifyExpectationExpectationType(dto);
        this.verifyExpectationKwargs(dto);
        this.verifyExpectationMeta(dto);
    }

    private void verifyExpectationMeta(ExpectationDTO dto) throws FeaturestoreException {
        String meta = dto.getMeta();
        if (meta == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_NULLABLE, Level.SEVERE, "Expectation meta cannot be null. Pass a stringified JSON.");
        }
        if (meta.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Expectation Meta field %s exceeds the max allowed character length %d.", meta, 1000));
        }
        try {
            new JSONObject(meta);
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_VALID_JSON, Level.SEVERE, String.format("Expectation Meta field %s is not a valid json.", meta), e.getMessage());
        }
    }

    private void verifyExpectationKwargs(ExpectationDTO dto) throws FeaturestoreException {
        String kwargs = dto.getKwargs();
        if (kwargs == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_NULLABLE, Level.SEVERE, "Expectation Kwargs cannot be null. Pass a stringified JSON.");
        }
        if (kwargs.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Expectation Kwargs field %s exceeds the max allowed character length %d.", kwargs, 1000));
        }
        try {
            new JSONObject(kwargs);
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_VALID_JSON, Level.SEVERE, String.format("Expectation Kwargs field %s is not a valid json.", kwargs), e.getMessage());
        }
    }

    private void verifyExpectationExpectationType(ExpectationDTO dto) throws FeaturestoreException {
        String expectationType = dto.getExpectationType();
        if (expectationType == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_NULLABLE, Level.SEVERE, "Expectation Expectation Type cannot be null. Pass a supported expectation type.");
        }
        if (expectationType.length() > 150) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Expectation Expectation Type field %s exceeds the max allowed character length %d.", expectationType, 150));
        }
    }
}

