/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.statistics;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeaturestoreStatistic;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import java.sql.Timestamp;
import java.util.Set;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class FeaturestoreStatisticFacade
extends AbstractFacade<FeaturestoreStatistic> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeaturestoreStatisticFacade() {
        super(FeaturestoreStatistic.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public AbstractFacade.CollectionInfo findByFeaturegroup(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, Featuregroup featuregroup) {
        String queryStr = this.buildQuery("SELECT s from FeaturestoreStatistic s ", filters, sorts, "s.featureGroup = :featureGroup");
        String queryCountStr = this.buildQuery("SELECT COUNT(s.id) from FeaturestoreStatistic s ", filters, sorts, "s.featureGroup = :featureGroup");
        TypedQuery query = this.em.createQuery(queryStr, FeaturestoreStatistic.class).setParameter("featureGroup", (Object)featuregroup);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, FeaturestoreStatistic.class).setParameter("featureGroup", (Object)featuregroup);
        this.setFilter(filters, (Query)query);
        this.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public AbstractFacade.CollectionInfo findByTrainingDataset(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, TrainingDataset trainingDataset, boolean forTransformation) {
        String queryStr = this.buildQuery("SELECT s from FeaturestoreStatistic s ", filters, sorts, "s.trainingDataset = :trainingDataset AND s.forTransformation = :forTransformation");
        String queryCountStr = this.buildQuery("SELECT COUNT(s.id) from FeaturestoreStatistic s ", filters, sorts, "s.trainingDataset = :trainingDataset AND s.forTransformation = :forTransformation");
        TypedQuery query = this.em.createQuery(queryStr, FeaturestoreStatistic.class).setParameter("trainingDataset", (Object)trainingDataset).setParameter("forTransformation", (Object)forTransformation);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, FeaturestoreStatistic.class).setParameter("trainingDataset", (Object)trainingDataset).setParameter("forTransformation", (Object)forTransformation);
        this.setFilter(filters, (Query)query);
        this.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            q.setParameter(filterBy.getField(), (Object)new Timestamp(Long.parseLong(filterBy.getParam())));
        }
    }

    public static enum Filters {
        COMMIT_TIME_GT("COMMIT_TIME_GT", "s.commitTime > :commitTime ", "commitTime", ""),
        COMMIT_TIME_LT("COMMIT_TIME_LT", "s.commitTime < :commitTime ", "commitTime", ""),
        COMMIT_TIME_EQ("COMMIT_TIME_EQ", "s.commitTime = :commitTime ", "commitTime", "");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        COMMIT_TIME("COMMIT_TIME", "s.commitTime ", "DESC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }
}

