/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.project;

import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import javax.enterprise.inject.Instance;

public interface ProjectHandler {
    public void preCreate(Project var1) throws Exception;

    public void postCreate(Project var1) throws Exception;

    public void preDelete(Project var1) throws Exception;

    public void postDelete(Project var1) throws Exception;

    public String getClassName();

    public static void runProjectPreCreateHandlers(Instance<ProjectHandler> projectHandlers, Project project) throws ProjectException {
        for (ProjectHandler projectHandler : projectHandlers) {
            try {
                projectHandler.preCreate(project);
            }
            catch (Exception e) {
                throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_HANDLER_PRECREATE_ERROR, Level.SEVERE, e.getMessage(), "project: " + project.getName() + ", handler: " + projectHandler.getClassName(), (Throwable)e);
            }
        }
    }

    public static void runProjectPostCreateHandlers(Instance<ProjectHandler> projectHandlers, Project project) throws ProjectException {
        for (ProjectHandler projectHandler : projectHandlers) {
            try {
                projectHandler.postCreate(project);
            }
            catch (Exception e) {
                throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_HANDLER_POSTCREATE_ERROR, Level.SEVERE, e.getMessage(), "project: " + project.getName() + ", handler: " + projectHandler.getClassName(), (Throwable)e);
            }
        }
    }

    public static void runProjectPreDeleteHandlers(Instance<ProjectHandler> projectHandlers, Project project) throws ProjectException {
        for (ProjectHandler projectHandler : projectHandlers) {
            try {
                projectHandler.preDelete(project);
            }
            catch (Exception e) {
                throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_HANDLER_PREDELETE_ERROR, Level.SEVERE, "project: " + project.getName() + ", handler: " + projectHandler.getClassName(), e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void runProjectPostDeleteHandlers(Instance<ProjectHandler> projectHandlers, Project project) throws ProjectException {
        for (ProjectHandler projectHandler : projectHandlers) {
            try {
                projectHandler.postDelete(project);
            }
            catch (Exception e) {
                throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_HANDLER_POSTDELETE_ERROR, Level.SEVERE, "project: " + project.getName() + ", handler: " + projectHandler.getClassName(), e.getMessage(), (Throwable)e);
            }
        }
    }
}

