/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jobhistory;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.jobs.history.YarnApplicationstate;
import java.util.EnumSet;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;

@Stateless
public class YarnApplicationstateFacade
extends AbstractFacade<YarnApplicationstate> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public YarnApplicationstateFacade() {
        super(YarnApplicationstate.class);
    }

    public EnumSet<YarnApplicationState> getRunningStates() {
        return EnumSet.of(YarnApplicationState.NEW, new YarnApplicationState[]{YarnApplicationState.GENERATING_SECURITY_MATERIAL, YarnApplicationState.NEW_SAVING, YarnApplicationState.SUBMITTED, YarnApplicationState.ACCEPTED, YarnApplicationState.RUNNING});
    }

    @Override
    public List<YarnApplicationstate> findAll() {
        TypedQuery query = this.em.createNamedQuery("YarnApplicationstate.findAll", YarnApplicationstate.class);
        return query.getResultList();
    }

    public List<YarnApplicationstate> findByAppname(String appname) {
        TypedQuery query = this.em.createNamedQuery("YarnApplicationstate.findByAppname", YarnApplicationstate.class).setParameter("appname", (Object)appname);
        return query.getResultList();
    }

    public List<YarnApplicationstate> findByAppuserAndAppState(String appUser, String appState) {
        TypedQuery query = this.em.createNamedQuery("YarnApplicationstate.findByAppuserAndAppsmstate", YarnApplicationstate.class).setParameter("appuser", (Object)appUser).setParameter("appsmstate", (Object)appState);
        return query.getResultList();
    }

    public YarnApplicationstate findByAppId(String appId) {
        try {
            return (YarnApplicationstate)this.em.createNamedQuery("YarnApplicationstate.findByApplicationid", YarnApplicationstate.class).setParameter("applicationid", (Object)appId).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

