/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.message;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.message.MessageFacade;
import io.hops.hopsworks.persistence.entity.message.Message;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class MessageController {
    private static final Logger logger = Logger.getLogger(MessageController.class.getName());
    public final String REPLY_SEPARATOR = "<hr>";
    public final int MAX_MESSAGE_SIZE = 65000;
    public final String MORE_MESSAGES = "Too many messages to show...";
    @EJB
    private MessageFacade messageFacade;

    public void reply(Users user, Message msg, String reply) {
        Date now = new Date();
        if (msg.getFrom() == null) {
            throw new IllegalArgumentException("Message does not contain a sender.");
        }
        if (reply == null || reply.isEmpty()) {
            throw new IllegalArgumentException("Message is empty.");
        }
        if (reply.length() > 65000) {
            throw new IllegalArgumentException("Message too long.");
        }
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(msg.getDateSent());
        String dateAndWriter = "On " + date + ", " + user.getFname() + " " + user.getLname() + " wrote: <br><br>";
        String replyMsg = "<hr>" + dateAndWriter + reply + msg.getContent();
        if (replyMsg.length() > 65000) {
            replyMsg = "<hr>" + dateAndWriter + reply + "Too many messages to show...";
        }
        boolean newMessage = false;
        Message newMsg = msg.getReplyToMsg();
        if (newMsg != null) {
            newMsg = this.messageFacade.findMessageById(newMsg.getId());
        } else {
            newMessage = true;
            newMsg = new Message(user, msg.getFrom(), now);
            newMsg.setReplyToMsg(msg);
        }
        newMsg.setUnread(true);
        newMsg.setDeleted(false);
        newMsg.setContent(replyMsg);
        String preview = user.getFname() + " replied ";
        if (msg.getSubject() != null) {
            preview = preview + "to  your " + msg.getSubject().toLowerCase();
        }
        newMsg.setPreview(preview);
        if (newMessage) {
            this.messageFacade.save(newMsg);
        } else {
            this.messageFacade.update(newMsg);
        }
        msg.setContent(replyMsg);
        if (msg.getReplyToMsg() == null) {
            msg.setReplyToMsg(newMsg);
        }
        this.messageFacade.update(msg);
    }

    public void send(Users to, Users from, String subject, String preview, String msg, String requestPath) {
        Date now = new Date();
        if (to == null) {
            throw new IllegalArgumentException("No recipient specified.");
        }
        if (msg == null || msg.isEmpty()) {
            throw new IllegalArgumentException("Message is empty.");
        }
        if (msg.length() > 65000) {
            throw new IllegalArgumentException("Message too long.");
        }
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(now);
        String dateAndWriter = "On " + date + ", " + from.getFname() + " " + from.getLname() + " wrote: <br><br>";
        String message = "<hr>" + dateAndWriter + msg;
        Message newMsg = new Message(from, to, now, message, true, false);
        newMsg.setPath(requestPath);
        newMsg.setSubject(subject);
        newMsg.setPreview(preview);
        this.messageFacade.save(newMsg);
    }

    public void send(Message msg) {
        Date now = new Date();
        if (msg.getTo() == null) {
            throw new IllegalArgumentException("No recipient specified.");
        }
        if (Strings.isNullOrEmpty((String)msg.getContent())) {
            throw new IllegalArgumentException("Message is empty.");
        }
        if (msg.getContent().length() > 65000) {
            throw new IllegalArgumentException("Message too long.");
        }
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(now);
        String dateAndWriter = "On " + date + ", " + msg.getFrom().getFname() + " " + msg.getFrom().getLname() + " wrote: <br><br>";
        msg.setDateSent(now);
        String message = "<hr>" + dateAndWriter + msg.getContent();
        msg.setContent(message);
        this.messageFacade.save(msg);
    }

    public void sendToMany(List<Users> recipients, Users from, String subject, String msg, String requestPath) {
        Date now = new Date();
        if (recipients == null || recipients.isEmpty()) {
            throw new IllegalArgumentException("No recipient specified.");
        }
        if (msg == null || msg.isEmpty()) {
            throw new IllegalArgumentException("Message is empty.");
        }
        if (msg.length() > 65000) {
            throw new IllegalArgumentException("Message too long.");
        }
        for (Users u : recipients) {
            Message newMsg = new Message(from, u, now, msg, true, false);
            newMsg.setPath(requestPath);
            newMsg.setSubject(subject);
            this.messageFacade.save(newMsg);
        }
    }

    public void remove(Message msg) {
        this.messageFacade.remove(msg);
    }
}

