/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.serving.monitor;

import io.hops.hopsworks.common.dao.serving.ServingFacade;
import io.hops.hopsworks.common.serving.LocalhostServingController;
import io.hops.hopsworks.common.serving.ServingController;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServingException;
import io.hops.hopsworks.persistence.entity.serving.ModelServer;
import io.hops.hopsworks.persistence.entity.serving.Serving;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.inject.Inject;

@Singleton
@Startup
public class LocalhostServingMonitor {
    private static final Logger LOGGER = Logger.getLogger(LocalhostServingMonitor.class.getName());
    @Resource
    private TimerService timerService;
    @EJB
    private ServingFacade servingFacade;
    @EJB
    private Settings settings;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @Inject
    private ServingController servingController;
    private String tfScript;
    private String sklearnScript;

    @PostConstruct
    public void init() {
        if (this.servingController.getClassName().equals(LocalhostServingController.class.getName())) {
            String rawInterval = this.settings.getServingMonitorInt();
            Long intervalValue = this.settings.getConfTimeValue(rawInterval);
            TimeUnit intervalTimeunit = this.settings.getConfTimeTimeUnit(rawInterval);
            LOGGER.log(Level.INFO, "Localhost Serving instances monitor is configure to run every" + intervalValue + " " + intervalTimeunit.name());
            intervalValue = intervalTimeunit.toMillis(intervalValue);
            this.timerService.createTimer(intervalValue.longValue(), intervalValue.longValue(), (Serializable)((Object)"Localhost Serving instances monitor"));
            this.tfScript = this.settings.getSudoersDir() + "/tfserving.sh";
            this.sklearnScript = this.settings.getSudoersDir() + "/sklearn_serving.sh";
        }
    }

    @Timeout
    public void monitor(Timer timer) {
        try {
            List<Serving> servingList = this.servingFacade.getLocalhostRunning();
            for (Serving serving : servingList) {
                try {
                    Serving dbServing = this.servingFacade.acquireLock(serving.getProject(), serving.getId());
                    ProcessDescriptor.Builder builder = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo");
                    if (serving.getModelServer() == ModelServer.TENSORFLOW_SERVING) {
                        builder.addCommand(this.tfScript);
                    }
                    if (serving.getModelServer() == ModelServer.PYTHON) {
                        builder.addCommand(this.sklearnScript);
                    }
                    ProcessDescriptor processDescriptor = builder.addCommand("alive").addCommand(dbServing.getProject().getName().toLowerCase()).addCommand(dbServing.getName()).ignoreOutErrStreams(true).build();
                    LOGGER.log(Level.FINE, processDescriptor.toString());
                    try {
                        ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
                        if (processResult.getExitCode() != 0) {
                            dbServing.setCid("failed");
                            this.servingFacade.updateDbObject(dbServing, dbServing.getProject());
                        }
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "Could not check if serving with id  '" + serving.getId() + "' is alive", e);
                    }
                    catch (ServingException e) {
                        LOGGER.log(Level.SEVERE, "Could not update status of serving with id: " + serving.getId(), e);
                    }
                    this.servingFacade.releaseLock(serving.getProject(), serving.getId());
                }
                catch (ServingException e) {
                    LOGGER.log(Level.INFO, "Error processing serving instance with id: " + serving.getId(), e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Got an exception while monitoring servings", e);
        }
    }
}

