/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.ondemand;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.ondemand.OnDemandOptionDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.ondemand.OnDemandDataFormat;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.ondemand.OnDemandFeature;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@JsonTypeName(value="onDemandFeaturegroupDTO")
public class OnDemandFeaturegroupDTO
extends FeaturegroupDTO {
    private FeaturestoreStorageConnectorDTO storageConnector;
    private String query;
    private OnDemandDataFormat dataFormat;
    private String path;
    private List<OnDemandOptionDTO> options;

    public OnDemandFeaturegroupDTO() {
    }

    public OnDemandFeaturegroupDTO(String featureStoreName, Featuregroup featuregroup, FeaturestoreStorageConnectorDTO storageConnectorDTO) {
        super(featuregroup);
        this.query = featuregroup.getOnDemandFeaturegroup().getQuery();
        this.storageConnector = storageConnectorDTO;
        this.dataFormat = featuregroup.getOnDemandFeaturegroup().getDataFormat();
        this.path = featuregroup.getOnDemandFeaturegroup().getPath();
        this.options = featuregroup.getOnDemandFeaturegroup().getOptions().stream().map(o -> new OnDemandOptionDTO(o.getName(), o.getValue())).collect(Collectors.toList());
        this.setFeaturestoreName(featureStoreName);
        this.setDescription(featuregroup.getOnDemandFeaturegroup().getDescription());
        this.setFeatures(featuregroup.getOnDemandFeaturegroup().getFeatures().stream().sorted(Comparator.comparing(OnDemandFeature::getIdx)).map(fgFeature -> new FeatureGroupFeatureDTO(fgFeature.getName(), fgFeature.getType(), fgFeature.getDescription(), featuregroup.getId(), fgFeature.getPrimary())).collect(Collectors.toList()));
    }

    public OnDemandFeaturegroupDTO(Featuregroup featuregroup, FeaturestoreStorageConnectorDTO storageConnectorDTO) {
        super(featuregroup);
        this.query = featuregroup.getOnDemandFeaturegroup().getQuery();
        this.storageConnector = storageConnectorDTO;
        this.dataFormat = featuregroup.getOnDemandFeaturegroup().getDataFormat();
        this.path = featuregroup.getOnDemandFeaturegroup().getPath();
        this.options = featuregroup.getOnDemandFeaturegroup().getOptions().stream().map(o -> new OnDemandOptionDTO(o.getName(), o.getValue())).collect(Collectors.toList());
    }

    public FeaturestoreStorageConnectorDTO getStorageConnector() {
        return this.storageConnector;
    }

    public void setStorageConnector(FeaturestoreStorageConnectorDTO storageConnector) {
        this.storageConnector = storageConnector;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public OnDemandDataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(OnDemandDataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<OnDemandOptionDTO> getOptions() {
        return this.options;
    }

    public void setOptions(List<OnDemandOptionDTO> options) {
        this.options = options;
    }
}

