/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.logging.Logger;

public class IoUtils {
    private static final Logger logger = Logger.getLogger(IoUtils.class.getName());

    public static String readContentFromClasspath(String path) throws IOException {
        URL url = IoUtils.class.getResource(path);
        if (url == null) {
            throw new IOException("No config.props file found in cookbook");
        }
        return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
    }

    public static String readContentFromPath(String path) throws IOException {
        return IoUtils.readContentFromPath(new File(path));
    }

    public static String readContentFromPath(File file) throws IOException {
        return Files.toString((File)file, (Charset)Charsets.UTF_8);
    }

    public static List<String> readLinesFromClasspath(String url) throws IOException {
        return Resources.readLines((URL)Resources.getResource((String)url), (Charset)Charsets.UTF_8);
    }

    public static List<String> readLinesFromPath(String url) throws IOException {
        return Files.readLines((File)new File(url), (Charset)Charsets.UTF_8);
    }

    public static List<String> readLinesFromWeb(String url) throws IOException {
        URL fileUrl = new URL(url);
        return Resources.readLines((URL)fileUrl, (Charset)Charsets.UTF_8);
    }

    public static String readContentFromWeb(String url) throws IOException {
        URL fileUrl = new URL(url);
        return Resources.toString((URL)fileUrl, (Charset)Charsets.UTF_8);
    }
}

