/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.updates.analyzer;

import io.hops.hopsworks.common.python.library.LibraryVersionDTO;
import io.hops.hopsworks.common.python.updates.analyzer.LatestVersionAnalyzer;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class HsmlLatestVersionAnalyzer
extends LatestVersionAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(HsmlLatestVersionAnalyzer.class.getName());

    @Override
    public String getLibrary() {
        return "hsml";
    }

    @Override
    public void setLatestVersion(String currentHopsworksVersion, HashMap<String, List<LibraryVersionDTO>> versions) {
        if (versions != null && !versions.isEmpty() && versions.containsKey(this.getLibrary())) {
            List<LibraryVersionDTO> searchVersionHits = versions.get(this.getLibrary());
            searchVersionHits = super.filterReleases(searchVersionHits);
            String[] hopsworksVersionSplit = currentHopsworksVersion.split("\\.");
            String hsmlVersionPrefix = hopsworksVersionSplit[0] + "." + hopsworksVersionSplit[1];
            List currentVersionSearchHits = searchVersionHits.stream().filter(version -> version.getVersion().startsWith(hsmlVersionPrefix)).collect(Collectors.toList());
            if (!(currentVersionSearchHits = currentVersionSearchHits.stream().sorted(new LatestVersionAnalyzer.SortByVersionComparator()).collect(Collectors.toList())).isEmpty()) {
                this.latestVersion = ((LibraryVersionDTO)currentVersionSearchHits.get(currentVersionSearchHits.size() - 1)).getVersion();
            } else {
                LOGGER.log(Level.SEVERE, "Could not find library version for " + this.getLibrary() + " for hopsworks version " + currentHopsworksVersion);
            }
        } else {
            LOGGER.log(Level.SEVERE, "Could not find library " + this.getLibrary() + " in PyPi search");
        }
    }
}

