/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.datavalidationv2.results;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.datavalidationv2.expectations.ExpectationFacade;
import io.hops.hopsworks.common.featurestore.datavalidationv2.results.ValidationResultDTO;
import io.hops.hopsworks.common.featurestore.datavalidationv2.results.ValidationResultFacade;
import io.hops.hopsworks.common.featurestore.datavalidationv2.suites.ExpectationSuiteController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.Expectation;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.ValidationReport;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.ValidationResult;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.json.JSONException;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ValidationResultController {
    private static final Logger LOGGER = Logger.getLogger(ExpectationSuiteController.class.getName());
    @EJB
    private ValidationResultFacade validationResultFacade;
    @EJB
    private ExpectationFacade expectationFacade;
    @EJB
    private FeaturestoreFacade featurestoreFacade;

    public AbstractFacade.CollectionInfo<ValidationResult> getAllValidationResultByExpectationId(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, Integer expectationId) throws FeaturestoreException {
        Optional<Expectation> optExpectation = this.expectationFacade.findById(expectationId);
        if (!optExpectation.isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.EXPECTATION_NOT_FOUND, Level.WARNING, "Expectation with id %d does not exist.");
        }
        return this.validationResultFacade.findByExpectation(offset, limit, sorts, filters, optExpectation.get());
    }

    public ValidationResult convertResultDTOToPersistent(ValidationReport report, ValidationResultDTO dto) throws FeaturestoreException {
        this.verifyValidationResultDTOFields(dto);
        ValidationResult result = new ValidationResult();
        result.setMeta(dto.getMeta());
        result.setSuccess(dto.getSuccess());
        result.setValidationReport(report);
        result.setIngestionResult(report.getIngestionResult());
        result.setValidationTime(report.getValidationTime());
        result.setExpectation(this.parseExpectationIdFromResultDTO(dto.getExpectationConfig()));
        if (dto.getResult().length() > 1000) {
            result.setResult(this.validationResultShortenResultField(dto.getResult()));
        } else {
            result.setResult(dto.getResult());
        }
        if (dto.getExceptionInfo().length() > 1000) {
            result.setExceptionInfo(this.validationResultShortenExceptionInfoField(dto.getExceptionInfo()));
        } else {
            result.setExceptionInfo(dto.getExceptionInfo());
        }
        if (dto.getExpectationConfig().length() > 2150) {
            result.setExpectationConfig(this.validationResultShortenExpectationConfigField(dto.getExpectationConfig(), result.getExpectation().getId()));
        } else {
            result.setExpectationConfig(dto.getExpectationConfig());
        }
        return result;
    }

    private Expectation parseExpectationIdFromResultDTO(String dtoExpectationConfig) throws FeaturestoreException {
        Integer expectationId;
        JSONObject meta;
        JSONObject expectationConfig;
        try {
            expectationConfig = new JSONObject(dtoExpectationConfig);
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_VALID_JSON, Level.SEVERE, String.format("Validation result expectation config field %s is not a valid json.", dtoExpectationConfig), e.getMessage());
        }
        try {
            meta = expectationConfig.getJSONObject("meta");
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_VALID_JSON, Level.SEVERE, String.format("Validation result expectation config meta field %s is not a valid json.", dtoExpectationConfig), e.getMessage());
        }
        try {
            expectationId = meta.getInt("expectationId");
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.KEY_NOT_FOUND_OR_INVALID_VALUE_TYPE_IN_JSON_OBJECT, Level.SEVERE, String.format("Validation result expectation config meta %s does not contain expectationId key or the associated value does not convert to an integer", meta), e.getMessage());
        }
        Optional<Expectation> expectation = this.expectationFacade.findById(expectationId);
        if (!expectation.isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.EXPECTATION_NOT_FOUND, Level.WARNING);
        }
        return expectation.get();
    }

    public String validationResultShortenResultField(String result) {
        JSONObject resultJson;
        try {
            resultJson = new JSONObject(result);
        }
        catch (JSONException e) {
            LOGGER.warning(String.format("Parsing result field threw JSONException that should have been handled when verifying input.\n%s\n%s", e.getMessage(), e.getStackTrace().toString()));
            resultJson = new JSONObject();
        }
        JSONObject shortResultJson = new JSONObject();
        String userMessage = "Result field exceeded max available space in SQL table, download validation report file to access the complete result.";
        shortResultJson.put("user_message", (Object)userMessage);
        if (resultJson.has("observed_value")) {
            shortResultJson.put("observed_value", (Object)resultJson.getString("observed_value"));
            if (shortResultJson.toString().length() > 1000) {
                shortResultJson.remove("observed_value");
                return shortResultJson.toString();
            }
        }
        if (resultJson.has("unexpected_count") && resultJson.has("partial_unexpected_list") && resultJson.has("unexpected_percent") && resultJson.has("unexpected_percent_nonmissing")) {
            shortResultJson.put("unexpected_count", resultJson.getInt("unexpected_count"));
            shortResultJson.put("unexpected_percent", resultJson.getFloat("unexpected_percent"));
            shortResultJson.put("unexpected_percent_nonmissing", resultJson.getFloat("unexpected_percent_nonmissing"));
            shortResultJson.put("partial_unexpected_list", (Object)resultJson.getString("partial_unexpected_list"));
            if (shortResultJson.toString().length() > 1000) {
                shortResultJson.remove("partial_unexpected_list");
                return shortResultJson.toString();
            }
        }
        return shortResultJson.toString();
    }

    public String validationResultShortenExceptionInfoField(String exceptionInfo) {
        JSONObject exceptionInfoJson;
        try {
            exceptionInfoJson = new JSONObject(exceptionInfo);
        }
        catch (JSONException e) {
            LOGGER.warning(String.format("Parsing exceptionInfo field threw JSONException that should have been handled when verifying input.\n%s\n%s", e.getMessage(), e.getStackTrace().toString()));
            exceptionInfoJson = new JSONObject();
        }
        JSONObject shortExceptionInfoJson = new JSONObject();
        String userMessage = "exception_info field exceeded max available space in SQL table, download validation report file to access the complete info.";
        shortExceptionInfoJson.put("user_message", (Object)userMessage);
        shortExceptionInfoJson.put("raised_exception", exceptionInfoJson.getBoolean("raised_exception"));
        shortExceptionInfoJson.put("exception_message", (Object)exceptionInfoJson.getString("exception_message"));
        if (shortExceptionInfoJson.toString().length() > 1000) {
            shortExceptionInfoJson.remove("exception_message");
            return shortExceptionInfoJson.toString();
        }
        return shortExceptionInfoJson.toString();
    }

    public String validationResultShortenExpectationConfigField(String expectationConfig, Integer expectationId) {
        JSONObject expectationConfigJson;
        try {
            expectationConfigJson = new JSONObject(expectationConfig);
        }
        catch (JSONException e) {
            LOGGER.warning(String.format("Parsing expectationConfig field threw JSONException that should have  been handled when verifying input.\n%s\n%s", e.getMessage(), e.getStackTrace().toString()));
            expectationConfigJson = new JSONObject();
        }
        JSONObject shortexpectationConfigJson = new JSONObject();
        JSONObject configMeta = new JSONObject();
        String userMessage = "expectation_config field exceeded max available space in SQL table, download validation report file to access the complete info. ";
        configMeta.put("userMessage", (Object)userMessage);
        configMeta.put("expectationId", (Object)expectationId);
        shortexpectationConfigJson.put("meta", (Object)configMeta);
        shortexpectationConfigJson.put("expectation_type", (Object)expectationConfigJson.getString("expectation_type"));
        shortexpectationConfigJson.put("kwargs", (Object)new JSONObject());
        return shortexpectationConfigJson.toString();
    }

    public JSONObject convertValidationResultDTOToJson(ValidationResultDTO resultDTO) throws FeaturestoreException {
        JSONObject resultJSON = new JSONObject();
        try {
            resultJSON.put("success", (Object)resultDTO.getSuccess());
            resultJSON.put("exception_info", (Object)new JSONObject(resultDTO.getExceptionInfo()));
            resultJSON.put("result", (Object)new JSONObject(resultDTO.getResult()));
            resultJSON.put("meta", (Object)new JSONObject(resultDTO.getMeta()));
            resultJSON.put("expectation_config", (Object)new JSONObject(resultDTO.getExpectationConfig()));
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.VALIDATION_RESULT_IS_NOT_VALID_JSON, Level.WARNING, e.getMessage());
        }
        return resultJSON;
    }

    public void verifyValidationResultDTOFields(ValidationResultDTO dto) throws FeaturestoreException {
        this.verifyValidationResultExceptionInfo(dto.getExceptionInfo());
        this.verifyValidationResultMeta(dto.getMeta());
        this.verifyValidationResultExpectationConfig(dto.getExpectationConfig());
        this.verifyValidationResultResult(dto.getResult());
    }

    public void verifyValidationResultMeta(String meta) throws FeaturestoreException {
        if (meta == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_NULLABLE, Level.SEVERE, "Validation result meta field cannot be null. Pass an empty stringified JSON.");
        }
        if (meta.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Validation result meta field %s exceeds the max allowed character length %d.", meta, 1000));
        }
        try {
            new JSONObject(meta);
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_VALID_JSON, Level.SEVERE, String.format("Validation result meta field %s is not a valid json.", meta), e.getMessage());
        }
    }

    public void verifyValidationResultExpectationConfig(String expectationConfig) throws FeaturestoreException {
        if (expectationConfig == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_NULLABLE, Level.SEVERE, "Validation result expectation config field cannot be null. Pass an empty stringified JSON.");
        }
        try {
            new JSONObject(expectationConfig);
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_VALID_JSON, Level.SEVERE, String.format("Validation result expectation config field %s is not a valid json.", expectationConfig), e.getMessage());
        }
    }

    public void verifyValidationResultExceptionInfo(String exceptionInfo) throws FeaturestoreException {
        if (exceptionInfo == null) {
            exceptionInfo = "{}";
            return;
        }
        try {
            new JSONObject(exceptionInfo);
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_VALID_JSON, Level.SEVERE, String.format("Validation result exception info field %s is not a valid json.", exceptionInfo), e.getMessage());
        }
    }

    public void verifyValidationResultResult(String result) throws FeaturestoreException {
        if (result == null) {
            result = "{}";
            return;
        }
        try {
            new JSONObject(result);
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_VALID_JSON, Level.SEVERE, String.format("Validation result result field %s is not a valid json.", result), e.getMessage());
        }
    }
}

