/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.yarn;

import io.hops.hopsworks.common.yarn.YarnClientService;
import io.hops.hopsworks.common.yarn.YarnClientWrapper;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;

public final class YarnMonitor
implements Closeable {
    private final YarnClientWrapper yarnClientWrapper;
    private final ApplicationId appId;
    private final YarnClientService ycs;

    public YarnMonitor(ApplicationId id, YarnClientWrapper yarnClientWrapper, YarnClientService ycs) {
        if (id == null) {
            throw new IllegalArgumentException("ApplicationId cannot be null for Yarn monitor!");
        }
        this.appId = id;
        this.yarnClientWrapper = yarnClientWrapper;
        this.ycs = ycs;
    }

    public void stop() {
        if (null != this.yarnClientWrapper) {
            this.ycs.closeYarnClient(this.yarnClientWrapper);
        }
    }

    public boolean isStarted() {
        return this.yarnClientWrapper.getYarnClient().isInState(Service.STATE.STARTED);
    }

    public boolean isStopped() {
        return this.yarnClientWrapper.getYarnClient().isInState(Service.STATE.STOPPED);
    }

    public YarnApplicationState getApplicationState() throws YarnException, IOException {
        return this.yarnClientWrapper.getYarnClient().getApplicationReport(this.appId).getYarnApplicationState();
    }

    public LogAggregationStatus getLogAggregationStatus() throws YarnException, IOException {
        return this.yarnClientWrapper.getYarnClient().getApplicationReport(this.appId).getLogAggregationStatus();
    }

    public FinalApplicationStatus getFinalApplicationStatus() throws YarnException, IOException {
        return this.yarnClientWrapper.getYarnClient().getApplicationReport(this.appId).getFinalApplicationStatus();
    }

    public float getProgress() throws YarnException, IOException {
        return this.yarnClientWrapper.getYarnClient().getApplicationReport(this.appId).getProgress();
    }

    public ApplicationId getApplicationId() {
        return this.appId;
    }

    @Override
    public void close() {
        this.stop();
    }

    public void cancelJob(String appid) throws YarnException, IOException {
        ApplicationId applicationId = ConverterUtils.toApplicationId((String)appid);
        this.yarnClientWrapper.getYarnClient().killApplication(applicationId);
    }

    public YarnClient getYarnClient() {
        return this.yarnClientWrapper.getYarnClient();
    }
}

