/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.dataset;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.hdfs.inode.InodeFacade;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith;
import io.hops.hopsworks.persistence.entity.dataset.DatasetType;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class DatasetSharedWithFacade
extends AbstractFacade<DatasetSharedWith> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    @EJB
    private InodeFacade inodeFacade;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public DatasetSharedWithFacade() {
        super(DatasetSharedWith.class);
    }

    public List<DatasetSharedWith> findByDataset(Dataset dataset) {
        return this.em.createNamedQuery("DatasetSharedWith.findByDataset", DatasetSharedWith.class).setParameter("dataset", (Object)dataset).getResultList();
    }

    public List<DatasetSharedWith> findByProject(Project project) {
        return this.em.createNamedQuery("DatasetSharedWith.findByProject", DatasetSharedWith.class).setParameter("project", (Object)project).getResultList();
    }

    public DatasetSharedWith findByProjectAndDataset(Project project, Dataset dataset) {
        try {
            return (DatasetSharedWith)this.em.createNamedQuery("DatasetSharedWith.findByProjectAndDataset", DatasetSharedWith.class).setParameter("project", (Object)project).setParameter("dataset", (Object)dataset).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public AbstractFacade.CollectionInfo findAllDatasetByProject(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort, Project project) {
        String queryStr = this.buildQuery("SELECT d FROM DatasetSharedWith d ", filter, sort, "d.project = :project ");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT d.id) FROM DatasetSharedWith d ", filter, null, "d.project = :project ");
        TypedQuery query = this.em.createQuery(queryStr, DatasetSharedWith.class).setParameter("project", (Object)project);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, DatasetSharedWith.class).setParameter("project", (Object)project);
        this.setFilter(filter, (Query)query, project);
        this.setFilter(filter, (Query)queryCount, project);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q, Project project) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q, project);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q, Project project) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case NAME: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam());
                break;
            }
            case ACCEPTED: 
            case PUBLIC: 
            case SHARED: 
            case SEARCHABLE: 
            case UNDER_CONSTRUCTION: {
                q.setParameter(filterBy.getField(), (Object)this.getBooleanValue(filterBy.getParam()));
                break;
            }
            case TYPE: {
                q.setParameter(filterBy.getField(), (Object)this.getEnumValue(filterBy.getField(), filterBy.getValue(), DatasetType.class));
                break;
            }
            case HDFS_USER: {
                q.setParameter(filterBy.getField(), (Object)this.inodeFacade.gethdfsUser(filterBy.getParam()));
                break;
            }
            case USER_EMAIL: {
                q.setParameter(filterBy.getField(), (Object)this.inodeFacade.getUsers(filterBy.getParam(), project));
                break;
            }
            case ACCESS_TIME: 
            case ACCESS_TIME_GT: 
            case ACCESS_TIME_LT: 
            case MODIFICATION_TIME: 
            case MODIFICATION_TIME_GT: 
            case MODIFICATION_TIME_LT: {
                Date date = this.getDate(filterBy.getField(), filterBy.getParam());
                q.setParameter(filterBy.getField(), (Object)date.getTime());
                break;
            }
            case SIZE: 
            case SIZE_LT: 
            case SIZE_GT: {
                q.setParameter(filterBy.getField(), (Object)this.getIntValue(filterBy));
                break;
            }
        }
    }

    public static enum Filters {
        NAME("NAME", "d.dataset.name LIKE CONCAT(:name, '%') ", "name", " "),
        USER_EMAIL("USER_EMAIL", "d.dataset.inode.hdfsUser =:user ", "user", " "),
        HDFS_USER("HDFS_USER", "d.dataset.inode.hdfsUser =:hdfsUser ", "hdfsUser", " "),
        UNDER_CONSTRUCTION("UNDER_CONSTRUCTION", "d.dataset.inode.underConstruction  =:underConstruction ", "underConstruction", "true"),
        ACCEPTED("ACCEPTED", "d.accepted =:accepted ", "accepted", "true"),
        SHARED("SHARED", "true =:shared ", "shared", "true"),
        SEARCHABLE("SEARCHABLE", "d.dataset.searchable =:searchable ", "searchable", "0"),
        TYPE("TYPE", "d.dataset.dsType =:dsType ", "dsType", "DATASET"),
        PUBLIC("PUBLIC", "d.dataset.public =:public ", "public", "0"),
        MODIFICATION_TIME("MODIFICATION_TIME", "d.dataset.inode.modificationTime  =:modificationTime ", "modificationTime", ""),
        MODIFICATION_TIME_LT("MODIFICATION_TIME_LT", "d.dataset.inode.modificationTime  <:modificationTime_lt ", "modificationTime_lt", ""),
        MODIFICATION_TIME_GT("MODIFICATION_TIME_GT", "d.dataset.inode.modificationTime  >:modificationTime_gt ", "modificationTime_gt", ""),
        ACCESS_TIME("ACCESS_TIME", "d.dataset.inode.accessTime  =:accessTime ", "accessTime", ""),
        ACCESS_TIME_LT("ACCESS_TIME_LT", "d.dataset.inode.accessTime  <:accessTime_lt ", "accessTime_lt", ""),
        ACCESS_TIME_GT("ACCESS_TIME_GT", "d.dataset.inode.accessTime  >:accessTime_gt ", "accessTime_gt", ""),
        SIZE("SIZE", "d.dataset.inode.size  =:size_eq ", "size_eq", "0"),
        SIZE_LT("SIZE_LT", "d.dataset.inode.size  <:size_lt ", "size_lt", "1"),
        SIZE_GT("SIZE_GT", "d.dataset.inode.size  >:size_gt ", "size_gt", "0");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", "d.dataset.id ", "ASC"),
        NAME("NAME", "LOWER(d.dataset.name) ", "ASC"),
        SEARCHABLE("SEARCHABLE", "d.dataset.searchable ", "ASC"),
        MODIFICATION_TIME("MODIFICATION_TIME", "d.dataset.inode.modificationTime ", "ASC"),
        ACCESS_TIME("ACCESS_TIME", "d.dataset.inode.accessTime ", "ASC"),
        PUBLIC("PUBLIC", "d.dataset.public ", "ASC"),
        SIZE("SIZE", "d.dataset.inode.size ", "ASC"),
        TYPE("TYPE", "d.dataset.dsType ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

