/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.user;

import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import javax.enterprise.inject.Instance;

public interface UserAccountHandler {
    public void create(Users var1) throws Exception;

    public void update(Users var1) throws Exception;

    public void remove(Users var1) throws Exception;

    public String getClassName();

    public static void runUserAccountCreateHandlers(Instance<UserAccountHandler> userAccountHandlers, Users user) throws UserException {
        for (UserAccountHandler handler : userAccountHandlers) {
            try {
                handler.create(user);
            }
            catch (Exception e) {
                String msg = "user: " + user.getUsername() + ", handler: " + handler.getClassName();
                throw new UserException(RESTCodes.UserErrorCode.USER_ACCOUNT_HANDLER_CREATE_ERROR, Level.SEVERE, e.getMessage(), msg, (Throwable)e);
            }
        }
    }

    public static void runUserAccountUpdateHandlers(Instance<UserAccountHandler> userAccountHandlers, Users user) throws UserException {
        for (UserAccountHandler handler : userAccountHandlers) {
            try {
                handler.update(user);
            }
            catch (Exception e) {
                String msg = "user: " + user.getUsername() + ", handler: " + handler.getClassName();
                throw new UserException(RESTCodes.UserErrorCode.USER_ACCOUNT_HANDLER_UPDATE_ERROR, Level.SEVERE, e.getMessage(), msg, (Throwable)e);
            }
        }
    }

    public static void runUserAccountDeleteHandlers(Instance<UserAccountHandler> userAccountHandlers, Users user) throws UserException {
        for (UserAccountHandler handler : userAccountHandlers) {
            try {
                handler.remove(user);
            }
            catch (Exception e) {
                throw new UserException(RESTCodes.UserErrorCode.USER_ACCOUNT_HANDLER_REMOVE_ERROR, Level.SEVERE, e.getMessage(), "user: " + user.getUsername() + ", status: " + user.getStatusName() + ", handler: " + handler.getClassName(), (Throwable)e);
            }
        }
    }
}

