/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.utils;

import com.google.common.base.Strings;
import com.google.common.net.InetAddresses;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.resolvers.Type;
import com.logicalclocks.servicediscoverclient.service.Service;
import com.logicalclocks.servicediscoverclient.service.ServiceQuery;
import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class FeaturestoreUtils {
    @EJB
    private ProjectTeamFacade projectTeamFacade;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;

    private void throwForbiddenOperation(Featurestore featureStore, String userRole, Project project, Object object, ActionMessage actionMessage) throws FeaturestoreException {
        ArrayList<String> messageContent = new ArrayList<String>();
        if (project != null) {
            messageContent.add(String.format("project: %s", project.getName()));
        }
        if (featureStore != null) {
            messageContent.add(String.format("featurestoreId: %s", featureStore.getId()));
        }
        if (userRole != null) {
            messageContent.add(String.format("userRole: %s", userRole));
        }
        if (object != null) {
            if (object instanceof Featuregroup) {
                Featuregroup featuregroup = (Featuregroup)object;
                messageContent.add(String.format("feature group: %s, version: %s", featuregroup.getName(), featuregroup.getVersion()));
            } else if (object instanceof TrainingDataset) {
                TrainingDataset trainingDataset = (TrainingDataset)object;
                messageContent.add(String.format("training dataset: %s, version: %s", trainingDataset.getName(), trainingDataset.getName()));
            } else if (object instanceof FeatureView) {
                FeatureView featureView = (FeatureView)object;
                messageContent.add(String.format("feature view: %s, version: %s", featureView.getName(), featureView.getVersion()));
            } else if (object instanceof FeaturestoreConnector) {
                FeaturestoreConnector featurestoreConnector = (FeaturestoreConnector)object;
                messageContent.add(String.format("storage connector: %s", featurestoreConnector.getName()));
            } else if (object instanceof Jobs) {
                Jobs job = (Jobs)object;
                messageContent.add(String.format("jobs: %s", job.getName()));
            }
        }
        if (actionMessage != null) {
            messageContent.add(String.format("actionMessage: %s", actionMessage.getMessage()));
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FORBIDDEN_FEATURESTORE_OPERATION, Level.FINE, String.join((CharSequence)", ", messageContent));
    }

    public void verifyUserProjectEqualsFsProject(Users user, Project project, Featurestore featureStore, ActionMessage actionMessage) throws FeaturestoreException {
        if (!featureStore.getProject().equals((Object)project)) {
            String userRole = this.projectTeamFacade.findCurrentRole(project, user);
            this.throwForbiddenOperation(featureStore, userRole, project, null, actionMessage);
        }
    }

    public void verifyUserProjectEqualsFsProjectAndDataOwner(Users user, Project project, Featurestore featureStore, ActionMessage actionMessage) throws FeaturestoreException {
        String userRole = this.projectTeamFacade.findCurrentRole(project, user);
        if (!featureStore.getProject().equals((Object)project) || !"Data owner".equalsIgnoreCase(userRole)) {
            this.throwForbiddenOperation(featureStore, userRole, project, null, actionMessage);
        }
    }

    public void verifyTrainingDatasetDataOwnerOrSelf(Users user, Project project, TrainingDataset trainingDataset, ActionMessage actionMessage) throws FeaturestoreException {
        String userRole = this.projectTeamFacade.findCurrentRole(project, user);
        if (!trainingDataset.getFeaturestore().getProject().equals((Object)project) || !"Data owner".equalsIgnoreCase(userRole) && !trainingDataset.getCreator().equals((Object)user)) {
            this.throwForbiddenOperation(trainingDataset.getFeaturestore(), userRole, project, trainingDataset, actionMessage);
        }
    }

    public void verifyFeatureViewDataOwnerOrSelf(Users user, Project project, FeatureView featureView, ActionMessage actionMessage) throws FeaturestoreException {
        String userRole = this.projectTeamFacade.findCurrentRole(project, user);
        if (!featureView.getFeaturestore().getProject().equals((Object)project) || !"Data owner".equalsIgnoreCase(userRole) && !featureView.getCreator().equals((Object)user)) {
            this.throwForbiddenOperation(featureView.getFeaturestore(), userRole, project, featureView, actionMessage);
        }
    }

    public String resolveLocationURI(String locationURI) throws ServiceException {
        URI uri = URI.create(locationURI);
        if (Strings.isNullOrEmpty((String)uri.getHost())) {
            return locationURI;
        }
        if (InetAddresses.isInetAddress((String)uri.getHost())) {
            return locationURI;
        }
        try {
            Service nn = this.serviceDiscoveryController.getService(Type.DNS, ServiceQuery.of((String)uri.getHost(), Collections.emptySet())).findAny().orElseThrow(() -> new ServiceException(RESTCodes.ServiceErrorCode.SERVICE_NOT_FOUND, Level.SEVERE, "Service Discovery is enabled but could not resolve domain " + uri.getHost()));
            return new URI(uri.getScheme(), uri.getUserInfo(), nn.getAddress(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
        }
        catch (ServiceDiscoveryException | URISyntaxException ex) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.SERVICE_NOT_FOUND, Level.SEVERE, "Service Discovery is enabled but could not resolve domain " + uri.getHost(), ex.getMessage(), ex);
        }
    }

    public String prependNameNode(String hdfsPath) throws ServiceDiscoveryException {
        Service namenode = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(ServiceDiscoveryController.HopsworksService.RPC_NAMENODE);
        return "hopsfs://" + namenode.getName() + ":" + namenode.getPort() + hdfsPath;
    }

    public static enum ActionMessage {
        CREATE_FEATURE_GROUP("Creating feature group"),
        CLEAR_FEATURE_GROUP("Clear feature group"),
        UPDATE_FEATURE_GROUP_METADATA("Update feature group metadata"),
        ENABLE_FEATURE_GROUP_ONLINE("Enable feature group online"),
        DISABLE_FEATURE_GROUP_ONLINE("Disable feature group online"),
        UPDATE_FEATURE_GROUP_STATS_CONFIG("Update feature group stats config"),
        DELETE_FEATURE_GROUP("Delete feature group"),
        CREATE_FEATURE_VIEW("Creating feature view"),
        DELETE_FEATURE_VIEW("Delete feature view"),
        UPDATE_FEATURE_VIEW("Update feature view"),
        CREATE_TRAINING_DATASET("Creating training dataset"),
        DELETE_TRAINING_DATASET("Delete training dataset"),
        DELETE_TRAINING_DATASET_DATA_ONLY("Delete training dataset data only"),
        DELETE_HOPSFS_TRAINING_DATASET("Delete hopsfs training data"),
        UPDATE_TRAINING_DATASET_METADATA("Update training dataset metadata"),
        UPDATE_TRAINING_DATASET_STATS_CONFIG("Update training dataset stats config"),
        SETUP_STATISTICS_JOB("Setup statistics job"),
        SETUP_VALIDATION_JOB("Setup validation job"),
        IMPORT_FEATURE_GROUP_JOB("Import feature group job"),
        SETUP_INGESTION_JOB("Setup ingestion job"),
        SETUP_TRAINING_DATASET_JOB("Setup training dataset job"),
        SETUP_HUDI_DELTA_STREAMER_JOB("Setup HUDI delta streamer job"),
        CREATE_STORAGE_CONNECTOR("Creating storage connector"),
        UPDATE_STORAGE_CONNECTOR("Update storage connector"),
        DELETE_STORAGE_CONNECTOR("Delete storage connector");

        private String message;

        private ActionMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

