/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featureview;

import io.hops.hopsworks.common.dao.QueryParam;
import io.hops.hopsworks.common.dao.user.activity.ActivityFacade;
import io.hops.hopsworks.common.featurestore.activity.FeaturestoreActivityFacade;
import io.hops.hopsworks.common.featurestore.app.FsJobManagerController;
import io.hops.hopsworks.common.featurestore.featureview.FeatureViewFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreConnectorFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetController;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetFacade;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreUtils;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.provenance.core.HopsFSProvenanceController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.JobException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.activity.FeaturestoreActivityMeta;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetFeature;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.activity.ActivityFlag;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeatureViewController {
    private static final String PATH_TO_FEATURE_VIEW = "%s/.featureviews/%s_%d";
    @EJB
    private FeatureViewFacade featureViewFacade;
    @EJB
    private InodeController inodeController;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private HdfsUsersController hdfsUsersBean;
    @EJB
    private FeaturestoreConnectorFacade featurestoreConnectorFacade;
    @EJB
    private HopsFSProvenanceController fsProvenanceController;
    @EJB
    private FeaturestoreActivityFacade fsActivityFacade;
    @EJB
    private FeaturestoreUtils featurestoreUtils;
    @EJB
    private TrainingDatasetFacade trainingDatasetFacade;
    @EJB
    private TrainingDatasetController trainingDatasetController;
    @EJB
    private ActivityFacade activityFacade;
    @Inject
    private FsJobManagerController fsJobManagerController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureView createFeatureView(Project project, Users user, FeatureView featureView, Featurestore featurestore) throws FeaturestoreException, ProvenanceException, IOException {
        this.featurestoreUtils.verifyUserProjectEqualsFsProject(user, project, featurestore, FeaturestoreUtils.ActionMessage.CREATE_FEATURE_VIEW);
        if (featureView.getVersion() == null) {
            Integer latestVersion = this.featureViewFacade.findLatestVersion(featureView.getName(), featurestore);
            if (latestVersion != null) {
                featureView.setVersion(Integer.valueOf(latestVersion + 1));
            } else {
                featureView.setVersion(Integer.valueOf(1));
            }
        }
        if (!this.featureViewFacade.findByNameVersionAndFeaturestore(featureView.getName(), featureView.getVersion(), featurestore).isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_VIEW_ALREADY_EXISTS, Level.FINE, "Feature view: " + featureView.getName() + ", version: " + featureView.getVersion());
        }
        List<TrainingDataset> trainingDatasets = this.trainingDatasetFacade.findByNameAndFeaturestoreExcludeFeatureView(featureView.getName(), featurestore);
        if (trainingDatasets != null && !trainingDatasets.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_VIEW_ALREADY_EXISTS, Level.FINE, "Name of the feature view collides with an existing training dataset name : " + featureView.getName());
        }
        String connectorName = featurestore.getProject().getName() + "_" + Settings.ServiceDataset.TRAININGDATASETS.getName();
        FeaturestoreConnector featurestoreConnector = this.featurestoreConnectorFacade.findByFeaturestoreName(featurestore, connectorName).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.HOPSFS_CONNECTOR_NOT_FOUND, Level.FINE, "HOPSFS Connector: " + connectorName));
        Dataset datasetsFolder = featurestoreConnector.getHopsfsConnector().getHopsfsDataset();
        DistributedFileSystemOps udfso = null;
        String username = this.hdfsUsersBean.getHdfsUserName(project, user);
        try {
            Path path = new Path(String.format(PATH_TO_FEATURE_VIEW, this.inodeController.getPath(datasetsFolder.getInode()), featureView.getName(), featureView.getVersion()));
            udfso = this.dfs.getDfsOps(username);
            udfso.mkdirs(path, FsPermission.getDefault());
            Inode inode = this.inodeController.getInodeAtPath(path.toString());
            featureView.setInode(inode);
            featureView = this.featureViewFacade.update(featureView);
            this.fsActivityFacade.logMetadataActivity(user, featureView, FeaturestoreActivityMeta.FV_CREATED);
            this.activityFacade.persistActivity(" created a new feature view " + featureView.getName(), project, user, ActivityFlag.SERVICE);
            this.fsProvenanceController.featureViewAttachXAttr(path.toString(), featureView, udfso);
            FeatureView featureView2 = featureView;
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
            return featureView2;
        }
        catch (Throwable throwable) {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
            throw throwable;
        }
    }

    public String getLocation(FeatureView featureView) {
        return this.inodeController.getPath(featureView.getInode());
    }

    public List<FeatureView> getAll() {
        return this.featureViewFacade.findAll();
    }

    public List<FeatureView> getByFeatureStore(Featurestore featurestore, QueryParam queryParam) {
        return this.featureViewFacade.findByFeaturestore(featurestore, queryParam);
    }

    public List<FeatureView> getByNameAndFeatureStore(String name, Featurestore featurestore, QueryParam queryParam) throws FeaturestoreException {
        List<FeatureView> featureViews = this.featureViewFacade.findByNameAndFeaturestore(name, featurestore, queryParam);
        if (featureViews.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_VIEW_NOT_FOUND, Level.FINE, String.format("There exists no feature view with the name %s.", name));
        }
        return featureViews;
    }

    public FeatureView getByNameVersionAndFeatureStore(String name, Integer version, Featurestore featurestore) throws FeaturestoreException {
        List<FeatureView> featureViews = this.featureViewFacade.findByNameVersionAndFeaturestore(name, version, featurestore);
        if (featureViews.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_VIEW_NOT_FOUND, Level.FINE, String.format("There exists no feature view with the name %s and version %d.", name, version));
        }
        return featureViews.get(0);
    }

    public void delete(Users user, Project project, Featurestore featurestore, String name) throws FeaturestoreException, JobException {
        List<FeatureView> featureViews = this.featureViewFacade.findByNameAndFeaturestore(name, featurestore);
        this.delete(user, project, featurestore, featureViews);
    }

    public void delete(Users user, Project project, Featurestore featurestore, String name, Integer version) throws FeaturestoreException, JobException {
        List<FeatureView> featureViews = this.featureViewFacade.findByNameVersionAndFeaturestore(name, version, featurestore);
        this.delete(user, project, featurestore, featureViews);
    }

    private void delete(Users user, Project project, Featurestore featurestore, List<FeatureView> featureViews) throws FeaturestoreException, JobException {
        if (featureViews == null || featureViews.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_VIEW_NOT_FOUND, Level.FINE, "Provided feature view name or version does not exist.");
        }
        for (FeatureView fv : featureViews) {
            this.featurestoreUtils.verifyFeatureViewDataOwnerOrSelf(user, project, fv, FeaturestoreUtils.ActionMessage.DELETE_FEATURE_VIEW);
        }
        String username = this.hdfsUsersBean.getHdfsUserName(project, user);
        for (FeatureView fv : featureViews) {
            this.trainingDatasetController.delete(user, project, featurestore, fv);
            this.featureViewFacade.remove(fv);
            this.removeFeatureViewDir(username, fv);
            this.fsJobManagerController.deleteJobs(project, user, fv);
            this.activityFacade.persistActivity(" deleted a feature view " + fv.getName(), project, user, ActivityFlag.SERVICE);
        }
    }

    private void removeFeatureViewDir(String username, FeatureView featureView) throws FeaturestoreException {
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(username);
        try {
            udfso.rm(this.getLocation(featureView), true);
        }
        catch (IOException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_DELETING_FEATURE_VIEW, Level.WARNING, "Error removing feature view directory", e.getMessage(), (Throwable)e);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    public FeatureView update(Users user, Project project, Featurestore featurestore, String name, Integer version, String description) throws FeaturestoreException {
        FeatureView featureView = this.getByNameVersionAndFeatureStore(name, version, featurestore);
        this.featurestoreUtils.verifyFeatureViewDataOwnerOrSelf(user, project, featureView, FeaturestoreUtils.ActionMessage.UPDATE_FEATURE_VIEW);
        featureView.setDescription(description);
        this.featureViewFacade.update(featureView);
        this.activityFacade.persistActivity(" edited a feature view " + name, project, user, ActivityFlag.SERVICE);
        return this.getByNameVersionAndFeatureStore(name, version, featurestore);
    }

    public List<TrainingDatasetFeature> getFeaturesSorted(Collection<TrainingDatasetFeature> features) {
        return features.stream().sorted((t1, t2) -> {
            if (t1.getIndex() != null) {
                return t1.getIndex().compareTo(t2.getIndex());
            }
            return t1.getName().compareTo(t2.getName());
        }).collect(Collectors.toList());
    }
}

