/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.core.opensearch;

import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.common.provenance.state.ProvStateParamBuilder;
import io.hops.hopsworks.common.provenance.util.functional.CheckedFunction;
import io.hops.hopsworks.common.provenance.util.functional.CheckedSupplier;
import io.hops.hopsworks.exceptions.OpenSearchException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.javatuples.Pair;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;

public class OpenSearchHelper {
    public static QueryBuilder fullTextSearch(String key, String term) {
        return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)key, (Object)term.toLowerCase())).should((QueryBuilder)QueryBuilders.prefixQuery((String)key, (String)term.toLowerCase())).should((QueryBuilder)QueryBuilders.fuzzyQuery((String)key, (String)term.toLowerCase())).should((QueryBuilder)QueryBuilders.wildcardQuery((String)key, (String)String.format("*%s*", term.toLowerCase())));
    }

    public static void checkPagination(Integer offset, Integer limit, long defaultPageSize) throws OpenSearchException {
        if (offset == null) {
            offset = 0;
        }
        if (offset < 0) {
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, "malformed - offset cannot be negative");
        }
        if (limit != null && (0 > limit || (long)limit.intValue() > defaultPageSize)) {
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, "malformed - limit not between 0 and ELASTIC_DEFAULT_SCROLL_PAGE_SIZE:" + defaultPageSize);
        }
    }

    public static CheckedSupplier<SearchRequest, ProvenanceException> scrollingSearchRequest(String index, int pageSize) {
        return () -> {
            SearchRequest sr = new SearchRequest(new String[]{index}).scroll(TimeValue.timeValueMinutes((long)1L));
            sr.source().size(pageSize);
            return sr;
        };
    }

    public static CheckedSupplier<SearchRequest, ProvenanceException> baseSearchRequest(String index, int pageSize) {
        return () -> {
            SearchRequest sr = new SearchRequest(new String[]{index});
            sr.source().size(pageSize);
            return sr;
        };
    }

    public static CheckedSupplier<SearchRequest, ProvenanceException> countSearchRequest(String index) {
        return () -> {
            SearchRequest sr = new SearchRequest(new String[]{index});
            sr.source().size(0);
            return sr;
        };
    }

    public static CheckedFunction<SearchRequest, SearchRequest, ProvenanceException> withPagination(Integer offset, Integer limit, long defaultPageSize) {
        return sr -> {
            try {
                OpenSearchHelper.checkPagination(offset, limit, defaultPageSize);
            }
            catch (OpenSearchException e) {
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, "query with malformed pagination", "query with malformed pagination", (Throwable)e);
            }
            if (offset != null) {
                sr.source().from(offset.intValue());
            }
            if (limit != null) {
                sr.source().size(limit.intValue());
            }
            return sr;
        };
    }

    public static CheckedFunction<SearchRequest, SearchRequest, ProvenanceException> withFileStateOrder(List<Pair<ProvParser.Field, SortOrder>> fileStateSortBy, List<ProvStateParamBuilder.SortE> xattrSortBy) {
        return sr -> {
            for (Object sb : fileStateSortBy) {
                sr.source().sort(SortBuilders.fieldSort((String)((ProvParser.Field)sb.getValue0()).openSearchFieldName()).order((SortOrder)sb.getValue1()));
            }
            for (Object sb : xattrSortBy) {
                sr.source().sort(SortBuilders.fieldSort((String)sb.key).order(sb.order));
            }
            return sr;
        };
    }

    public static CheckedFunction<SearchRequest, SearchRequest, ProvenanceException> withFileOpsOrder(List<Pair<ProvParser.Field, SortOrder>> fileOpsSortBy) {
        return sr -> {
            for (Pair sb : fileOpsSortBy) {
                sr.source().sort(SortBuilders.fieldSort((String)((ProvParser.Field)sb.getValue0()).openSearchFieldName()).order((SortOrder)sb.getValue1()));
            }
            return sr;
        };
    }

    public static CheckedFunction<SearchRequest, SearchRequest, ProvenanceException> withAggregations(List<AggregationBuilder> aggregationBuilder) {
        return sr -> {
            if (!aggregationBuilder.isEmpty()) {
                for (AggregationBuilder builder : aggregationBuilder) {
                    sr.source().aggregation(builder);
                }
            }
            return sr;
        };
    }

    public static BoolQueryBuilder filterByBasicFields(BoolQueryBuilder query, Map<ProvParser.Field, ProvParser.FilterVal> filters) throws ProvenanceException {
        for (ProvParser.FilterVal fieldFilters : filters.values()) {
            query.must(fieldFilters.query());
        }
        return query;
    }

    public static CheckedFunction<SearchRequest, SearchRequest, ProvenanceException> sortBy(List<Pair<ProvParser.Field, SortOrder>> sortBy) {
        return sr -> {
            for (Pair sb : sortBy) {
                sr.source().sort(SortBuilders.fieldSort((String)((ProvParser.Field)sb.getValue0()).openSearchFieldName()).order((SortOrder)sb.getValue1()));
            }
            return sr;
        };
    }

    public static boolean indexNotFound(Throwable t) {
        if (t instanceof IndexNotFoundException) {
            return true;
        }
        if (t instanceof OpenSearchStatusException) {
            OpenSearchStatusException e = (OpenSearchStatusException)t;
            return e.status().equals((Object)RestStatus.NOT_FOUND);
        }
        return false;
    }
}

