/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.ops;

import io.hops.hopsworks.common.provenance.ops.ProvLinks;
import io.hops.hopsworks.exceptions.ProvenanceException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.javatuples.Pair;

public class ProvLinksParamBuilder {
    boolean appIdDefined = false;
    boolean inArtifactDefined = false;
    boolean outArtifactDefined = false;
    boolean artifactDefined = false;
    Set<String> filterBy = new HashSet<String>();
    List<String> filterType = new ArrayList<String>();
    Pair<Integer, Integer> pagination = null;
    boolean fullLink = true;
    Pair<Integer, Integer> expand = null;
    boolean onlyApps = true;

    public ProvLinksParamBuilder filterByFields(Set<String> params) throws ProvenanceException {
        for (String param : params) {
            Pair<ProvLinks.Field, Object> filter = ProvLinks.extractFilter(param);
            this.filterBy((ProvLinks.Field)filter.getValue0(), filter.getValue1());
        }
        return this;
    }

    private void filterBy(ProvLinks.Field field, Object val) {
        if (field instanceof ProvLinks.FieldsPF) {
            ProvLinks.FieldsPF fieldPF = (ProvLinks.FieldsPF)field;
            switch (fieldPF) {
                case APP_ID: {
                    this.appIdDefined = true;
                    this.expand(1, 0);
                    this.filterBy.add(val.toString());
                    break;
                }
                case IN_ARTIFACT: {
                    this.inArtifactDefined = true;
                    this.expand(0, 1);
                    this.filterBy.add(val.toString());
                    break;
                }
                case IN_TYPE: 
                case OUT_TYPE: 
                case ARTIFACT_TYPE: {
                    this.filterType.addAll((List)val);
                    break;
                }
                case OUT_ARTIFACT: {
                    this.outArtifactDefined = true;
                    this.expand(1, 0);
                    this.filterBy.add(val.toString());
                    break;
                }
                case ARTIFACT: {
                    this.artifactDefined = true;
                    this.filterBy.add(val.toString());
                    break;
                }
                default: {
                    this.filterBy.add(val.toString());
                }
            }
        }
    }

    public ProvLinksParamBuilder onlyApps(boolean onlyApps) {
        this.onlyApps = onlyApps;
        return this;
    }

    public ProvLinksParamBuilder paginate(Integer offset, Integer limit) {
        this.pagination = Pair.with((Object)offset, (Object)limit);
        return this;
    }

    public ProvLinksParamBuilder linkType(boolean fullLink) {
        this.fullLink = fullLink;
        return this;
    }

    public ProvLinksParamBuilder expand(int expandUpstream, int expandDownstream) {
        this.expand = Pair.with((Object)expandUpstream, (Object)expandDownstream);
        return this;
    }

    public boolean isAppIdDefined() {
        return this.appIdDefined;
    }

    public boolean isInArtifactDefined() {
        return this.inArtifactDefined;
    }

    public boolean isOutArtifactDefined() {
        return this.outArtifactDefined;
    }

    public boolean isArtifactDefined() {
        return this.artifactDefined;
    }

    public Set<String> getFilterBy() {
        return this.filterBy;
    }

    public List<String> getFilterType() {
        return this.filterType;
    }

    public Pair<Integer, Integer> getPagination() {
        return this.pagination;
    }

    public boolean isFullLink() {
        return this.fullLink;
    }

    public Pair<Integer, Integer> getExpand() {
        return this.expand;
    }

    public boolean isOnlyApps() {
        return this.onlyApps;
    }
}

