/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretPlaintext;
import io.hops.hopsworks.common.featurestore.OptionDTO;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnectorType;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.secrets.Secret;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.json.JSONArray;
import org.json.JSONObject;

@Stateless
public class StorageConnectorUtil {
    @EJB
    private SecretsController secretsController;
    @EJB
    private UserFacade userFacade;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private Settings settings;
    private ObjectMapper objectMapper = new ObjectMapper();

    public StorageConnectorUtil() {
    }

    protected StorageConnectorUtil(Settings settings) {
        this.settings = settings;
    }

    public String createSecretName(Integer featurestoreId, String connectorName, FeaturestoreConnectorType connectorType) {
        return connectorType.toString().toLowerCase() + "_" + connectorName.replaceAll(" ", "_").toLowerCase() + "_" + featurestoreId;
    }

    public <T> T getSecret(Secret secret, Class<T> valueType) throws FeaturestoreException {
        Object secretClass = null;
        if (secret != null) {
            try {
                Users owner = (Users)this.userFacade.find(secret.getId().getUid());
                SecretPlaintext plainText = this.secretsController.getShared(owner, owner, secret.getId().getName());
                secretClass = valueType == String.class ? plainText.getPlaintext() : this.objectMapper.readValue(plainText.getPlaintext(), valueType);
            }
            catch (ProjectException | ServiceException | UserException | IOException e) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.STORAGE_CONNECTOR_GET_ERROR, Level.FINE, "Unable to retrieve Secret " + secret.getId().getName() + " for this storage connector.", e.getMessage());
            }
        }
        return (T)secretClass;
    }

    public <T> Secret createProjectSecret(Users user, String secretName, Featurestore featureStore, T secretClass) throws ProjectException, UserException {
        if (secretClass != null) {
            String jsonSecretString = this.serializeSecretClass(secretClass);
            return this.secretsController.createSecretForProject(user, secretName, jsonSecretString, featureStore.getProject().getId());
        }
        return null;
    }

    public <T> Secret updateProjectSecret(Users user, Secret secret, String secretName, Featurestore featureStore, T secretClass) throws ProjectException, UserException {
        if (secretClass != null && secret != null) {
            this.secretsController.checkCanAccessSecret(secret, user);
            try {
                secret.setSecret(this.secretsController.encryptSecret(this.serializeSecretClass(secretClass)));
            }
            catch (IOException | GeneralSecurityException e) {
                throw new UserException(RESTCodes.UserErrorCode.SECRET_ENCRYPTION_ERROR, Level.SEVERE, "Error encrypting secret", "Could not encrypt Secret " + secret.getId().getName(), (Throwable)e);
            }
            return secret;
        }
        if (secretClass != null) {
            return this.createProjectSecret(user, secretName, featureStore, secretClass);
        }
        return null;
    }

    public <T> String serializeSecretClass(T secretClass) {
        if (secretClass.getClass() == String.class) {
            return (String)secretClass;
        }
        return new JSONObject(secretClass).toString();
    }

    public List<OptionDTO> toOptions(String arguments) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)arguments)) {
            return null;
        }
        try {
            OptionDTO[] optionArray = (OptionDTO[])this.objectMapper.readValue(arguments, OptionDTO[].class);
            return Arrays.asList(optionArray);
        }
        catch (JsonProcessingException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.STORAGE_CONNECTOR_GET_ERROR, Level.SEVERE, "Error deserializing options list provided with connector", e.getMessage());
        }
    }

    public String fromOptions(List<OptionDTO> options) {
        if (options == null || options.isEmpty()) {
            return null;
        }
        return new JSONArray(options).toString();
    }

    public boolean shouldUpdate(String oldVal, String newVal) {
        return oldVal == null && newVal != null || oldVal != null && !oldVal.equals(newVal);
    }

    public boolean shouldUpdate(Integer oldVal, Integer newVal) {
        return oldVal == null && newVal != null || oldVal != null && !oldVal.equals(newVal);
    }

    public boolean isNullOrWhitespace(String val) {
        return Strings.isNullOrEmpty((String)val) || Strings.isNullOrEmpty((String)val.trim());
    }

    public String getValueOrNull(String val) {
        return this.isNullOrWhitespace(val) ? null : val.trim();
    }

    public void removeHdfsFile(Project project, Users user, String keyPath) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)keyPath)) {
            throw new IllegalArgumentException("File Path to delete cannot be null or empty");
        }
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(this.hdfsUsersController.getHdfsUserName(project, user));
        try {
            udfso.rm(keyPath, false);
        }
        catch (IOException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FAILURE_HDFS_USER_OPERATION, Level.SEVERE, "Error deleting file", e.getMessage());
        }
        finally {
            this.dfs.closeDfsClient(udfso);
        }
    }

    public Set<FeaturestoreConnectorType> getEnabledStorageConnectorTypes() {
        HashSet<FeaturestoreConnectorType> types = new HashSet<FeaturestoreConnectorType>();
        types.add(FeaturestoreConnectorType.JDBC);
        types.add(FeaturestoreConnectorType.HOPSFS);
        types.add(FeaturestoreConnectorType.S3);
        if (this.settings.isSnowflakeStorageConnectorsEnabled()) {
            types.add(FeaturestoreConnectorType.SNOWFLAKE);
        }
        if (this.settings.isRedshiftStorageConnectorsEnabled()) {
            types.add(FeaturestoreConnectorType.REDSHIFT);
        }
        if (this.settings.isAdlsStorageConnectorsEnabled()) {
            types.add(FeaturestoreConnectorType.ADLS);
        }
        if (this.settings.isKafkaStorageConnectorsEnabled()) {
            types.add(FeaturestoreConnectorType.KAFKA);
        }
        if (this.settings.isGcsStorageConnectorsEnabled()) {
            types.add(FeaturestoreConnectorType.GCS);
        }
        if (this.settings.isBigqueryStorageConnectorsEnabled()) {
            types.add(FeaturestoreConnectorType.BIGQUERY);
        }
        return types;
    }

    public boolean isStorageConnectorTypeEnabled(FeaturestoreConnectorType storageConnectorType) {
        switch (storageConnectorType) {
            case JDBC: 
            case HOPSFS: 
            case S3: {
                return true;
            }
            case REDSHIFT: {
                return this.settings.isRedshiftStorageConnectorsEnabled();
            }
            case ADLS: {
                return this.settings.isAdlsStorageConnectorsEnabled();
            }
            case SNOWFLAKE: {
                return this.settings.isSnowflakeStorageConnectorsEnabled();
            }
            case KAFKA: {
                return this.settings.isKafkaStorageConnectorsEnabled();
            }
            case GCS: {
                return this.settings.isGcsStorageConnectorsEnabled();
            }
            case BIGQUERY: {
                return this.settings.isBigqueryStorageConnectorsEnabled();
            }
        }
        throw new IllegalArgumentException("Unknown storage connector type: " + storageConnectorType);
    }
}

